/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.soundcloud;

import com.sedmelluq.discord.lavaplayer.player.DefaultAudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudAudioTrack;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.iblitzkriegi.vixio.org.apache.commons.io.IOUtils;
import me.iblitzkriegi.vixio.org.apache.http.HttpResponse;
import me.iblitzkriegi.vixio.org.apache.http.client.config.RequestConfig;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.CloseableHttpResponse;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.HttpGet;
import me.iblitzkriegi.vixio.org.apache.http.client.utils.URIBuilder;
import me.iblitzkriegi.vixio.org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundCloudAudioSourceManager
implements AudioSourceManager,
HttpConfigurable {
    private static final Logger log = LoggerFactory.getLogger(SoundCloudAudioSourceManager.class);
    private static final int DEFAULT_SEARCH_RESULTS = 10;
    private static final int MAXIMUM_SEARCH_RESULTS = 200;
    private static final long CLIENT_ID_REFRESH_INTERVAL = TimeUnit.HOURS.toMillis(1L);
    private static final String CHARSET = "UTF-8";
    private static final String LATEST_CLIENT_ID = "2t9loNQH90kzJcsFCODdigxfp325aq4z";
    private static final String TRACK_URL_REGEX = "^(?:http://|https://|)(?:www\\.|)soundcloud\\.com/([a-zA-Z0-9-_]+)/([a-zA-Z0-9-_]+)(?:\\?.*|)$";
    private static final String UNLISTED_URL_REGEX = "^(?:http://|https://|)(?:www\\.|)soundcloud\\.com/([a-zA-Z0-9-_]+)/([a-zA-Z0-9-_]+)/s-([a-zA-Z0-9-_]+)(?:\\?.*|)$";
    private static final String PLAYLIST_URL_REGEX = "^(?:http://|https://|)(?:www\\.|)soundcloud\\.com/([a-zA-Z0-9-_]+)/sets/([a-zA-Z0-9-_]+)(?:\\?.*|)$";
    private static final String LIKED_URL_REGEX = "^(?:http://|https://|)(?:www\\.|)soundcloud\\.com/([a-zA-Z0-9-_]+)/likes/?(?:\\?.*|)$";
    private static final String LIKED_USER_URN_REGEX = "\"urn\":\"soundcloud:users:([0-9]+)\",\"username\":\"([^\"]+)\"";
    private static final String SEARCH_PREFIX = "scsearch";
    private static final String SEARCH_PREFIX_DEFAULT = "scsearch:";
    private static final String SEARCH_REGEX = "scsearch\\[([0-9]{1,9}),([0-9]{1,9})\\]:\\s*(.*)\\s*";
    private static final String PAGE_APP_SCRIPT_REGEX = "https://[A-Za-z0-9-.]+/assets/app-[a-f0-9-]+\\.js";
    private static final String APP_SCRIPT_CLIENT_ID_REGEX = ",client_id:\"([a-zA-Z0-9-_]+)\"";
    private static final Pattern trackUrlPattern = Pattern.compile("^(?:http://|https://|)(?:www\\.|)soundcloud\\.com/([a-zA-Z0-9-_]+)/([a-zA-Z0-9-_]+)(?:\\?.*|)$");
    private static final Pattern unlistedUrlPattern = Pattern.compile("^(?:http://|https://|)(?:www\\.|)soundcloud\\.com/([a-zA-Z0-9-_]+)/([a-zA-Z0-9-_]+)/s-([a-zA-Z0-9-_]+)(?:\\?.*|)$");
    private static final Pattern playlistUrlPattern = Pattern.compile("^(?:http://|https://|)(?:www\\.|)soundcloud\\.com/([a-zA-Z0-9-_]+)/sets/([a-zA-Z0-9-_]+)(?:\\?.*|)$");
    private static final Pattern likedUrlPattern = Pattern.compile("^(?:http://|https://|)(?:www\\.|)soundcloud\\.com/([a-zA-Z0-9-_]+)/likes/?(?:\\?.*|)$");
    private static final Pattern likedUserUrnPattern = Pattern.compile("\"urn\":\"soundcloud:users:([0-9]+)\",\"username\":\"([^\"]+)\"");
    private static final Pattern searchPattern = Pattern.compile("scsearch\\[([0-9]{1,9}),([0-9]{1,9})\\]:\\s*(.*)\\s*");
    private static final Pattern pageAppScriptPattern = Pattern.compile("https://[A-Za-z0-9-.]+/assets/app-[a-f0-9-]+\\.js");
    private static final Pattern appScriptClientIdPattern = Pattern.compile(",client_id:\"([a-zA-Z0-9-_]+)\"");
    private final HttpInterfaceManager httpInterfaceManager = HttpClientTools.createDefaultThreadLocalManager();
    private final Object clientIdLock;
    private final boolean allowSearch;
    private long lastClientIdUpdate;
    private volatile String clientId;

    public SoundCloudAudioSourceManager() {
        this(true);
    }

    public SoundCloudAudioSourceManager(boolean allowSearch) {
        this.allowSearch = allowSearch;
        this.clientIdLock = new Object();
        this.lastClientIdUpdate = 0L;
        this.setClientId(LATEST_CLIENT_ID);
    }

    @Override
    public String getSourceName() {
        return "soundcloud";
    }

    @Override
    public AudioItem loadItem(DefaultAudioPlayerManager manager, AudioReference reference) {
        AudioItem track = this.processAsSingleTrack(reference);
        if (track == null) {
            track = this.processAsPlaylist(reference);
        }
        if (track == null && this.allowSearch) {
            track = this.processAsSearchQuery(reference);
        }
        return track;
    }

    @Override
    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    @Override
    public void encodeTrack(AudioTrack track, DataOutput output) throws IOException {
    }

    @Override
    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        return new SoundCloudAudioTrack(trackInfo, this);
    }

    @Override
    public void shutdown() {
    }

    public String getTrackUrlFromId(String trackId) {
        String[] parts = trackId.split("\\|");
        if (parts.length < 2) {
            return "https://api.soundcloud.com/tracks/" + trackId + "/stream?client_id=" + this.getClientId();
        }
        return "https://api.soundcloud.com/tracks/" + parts[0] + "/stream?client_id=" + this.getClientId() + "&secret_token=" + parts[1];
    }

    public HttpInterface getHttpInterface() {
        return this.httpInterfaceManager.getInterface();
    }

    @Override
    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        this.httpInterfaceManager.configureRequests(configurator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClientId() {
        Object object = this.clientIdLock;
        synchronized (object) {
            long now = System.currentTimeMillis();
            if (now - this.lastClientIdUpdate < CLIENT_ID_REFRESH_INTERVAL) {
                log.debug("Client ID was recently updated, not updating again right away.");
                return;
            }
            this.lastClientIdUpdate = now;
            log.info("Updating SoundCloud client ID (current is {}).", (Object)this.clientId);
            try {
                this.clientId = this.findClientIdFromSite();
                log.info("Updating SoundCloud client ID succeeded, new ID is {}.", (Object)this.clientId);
            }
            catch (Exception e) {
                log.error("SoundCloud client ID update failed.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientId(String clientId) {
        Object object = this.clientIdLock;
        synchronized (object) {
            this.clientId = clientId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClientId() {
        Object object = this.clientIdLock;
        synchronized (object) {
            return this.clientId;
        }
    }

    private String findClientIdFromSite() throws IOException {
        try (HttpInterface httpInterface = this.getHttpInterface();){
            String scriptUrl = this.findApplicationScriptUrl(httpInterface);
            String string = this.findClientIdFromApplicationScript(httpInterface, scriptUrl);
            return string;
        }
    }

    private String findApplicationScriptUrl(HttpInterface httpInterface) throws IOException {
        Throwable throwable = null;
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet("https://soundcloud.com"));){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new IOException("Invalid status code for main page response: " + statusCode);
            }
            String page = EntityUtils.toString(response.getEntity());
            Matcher scriptMatcher = pageAppScriptPattern.matcher(page);
            if (scriptMatcher.find()) {
                String string = scriptMatcher.group(0);
                return string;
            }
            try {
                throw new IllegalStateException("Could not find application script from main page.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private String findClientIdFromApplicationScript(HttpInterface httpInterface, String scriptUrl) throws IOException {
        Throwable throwable = null;
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(scriptUrl));){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new IOException("Invalid status code for application script response: " + statusCode);
            }
            String page = EntityUtils.toString(response.getEntity());
            Matcher clientIdMatcher = appScriptClientIdPattern.matcher(page);
            if (clientIdMatcher.find()) {
                String string = clientIdMatcher.group(1);
                return string;
            }
            try {
                throw new IllegalStateException("Could not find client ID from application script.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private AudioTrack processAsSingleTrack(AudioReference reference) {
        Matcher trackUrlMatcher = trackUrlPattern.matcher(reference.identifier);
        if (trackUrlMatcher.matches() && !"likes".equals(trackUrlMatcher.group(2))) {
            return this.loadFromTrackPage(reference.identifier, null);
        }
        Matcher unlistedUrlMatcher = unlistedUrlPattern.matcher(reference.identifier);
        if (unlistedUrlMatcher.matches()) {
            return this.loadFromTrackPage(reference.identifier, "s-" + unlistedUrlMatcher.group(3));
        }
        return null;
    }

    private AudioItem processAsPlaylist(AudioReference reference) {
        if (playlistUrlPattern.matcher(reference.identifier).matches()) {
            return this.loadFromSet(reference.identifier);
        }
        if (likedUrlPattern.matcher(reference.identifier).matches()) {
            return this.loadFromLikedTracks(reference.identifier);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AudioTrack loadFromTrackPage(String trackWebUrl, String secretToken) {
        try (HttpInterface httpInterface = this.getHttpInterface();){
            JsonBrowser trackInfoJson = this.loadTrackInfoFromJson(this.loadPageConfigJson(httpInterface, trackWebUrl));
            AudioTrack audioTrack = this.buildAudioTrack(trackInfoJson, secretToken);
            return audioTrack;
        }
        catch (IOException e) {
            throw new FriendlyException("Loading track from SoundCloud failed.", FriendlyException.Severity.SUSPICIOUS, e);
        }
    }

    private AudioTrack buildAudioTrack(JsonBrowser trackInfoJson, String secretToken) {
        String trackId = trackInfoJson.get("id").text();
        AudioTrackInfo trackInfo = new AudioTrackInfo(trackInfoJson.get("title").text(), trackInfoJson.get("user").get("username").text(), trackInfoJson.get("duration").as(Integer.class).intValue(), secretToken != null ? trackId + "|" + secretToken : trackId, false, trackInfoJson.get("permalink_url").text());
        return new SoundCloudAudioTrack(trackInfo, this);
    }

    private JsonBrowser loadPageConfigJson(HttpInterface httpInterface, String url) throws IOException {
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(url));){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 404) {
                throw new FriendlyException("That track does not exist.", FriendlyException.Severity.COMMON, null);
            }
            if (statusCode != 200) {
                throw new IOException("Invalid status code for video page response: " + statusCode);
            }
            String html = IOUtils.toString(response.getEntity().getContent(), Charset.forName(CHARSET));
            String configJson = DataFormatTools.extractBetween(html, "e}var c=", ",o=Date.now()");
            if (configJson == null) {
                throw new FriendlyException("This url does not appear to be a playable track.", FriendlyException.Severity.SUSPICIOUS, null);
            }
            JsonBrowser jsonBrowser = JsonBrowser.parse(configJson);
            return jsonBrowser;
        }
    }

    private JsonBrowser loadTrackInfoFromJson(JsonBrowser json) {
        for (JsonBrowser value : json.values()) {
            for (JsonBrowser entry : value.safeGet("data").values()) {
                if (!entry.isMap() || !"track".equals(entry.get("kind").text())) continue;
                return entry;
            }
        }
        throw new IllegalStateException("Could not find track information block.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AudioPlaylist loadFromSet(String playlistWebUrl) {
        try (HttpInterface httpInterface = this.getHttpInterface();){
            JsonBrowser playlistInfo = this.loadPlaylistInfoFromJson(this.loadPageConfigJson(httpInterface, playlistWebUrl));
            BasicAudioPlaylist basicAudioPlaylist = new BasicAudioPlaylist(playlistInfo.get("title").text(), this.loadTracksFromPlaylist(httpInterface, playlistInfo, playlistWebUrl), null, false);
            return basicAudioPlaylist;
        }
        catch (IOException e) {
            throw new FriendlyException("Loading playlist from SoundCloud failed.", FriendlyException.Severity.SUSPICIOUS, e);
        }
    }

    private JsonBrowser loadPlaylistInfoFromJson(JsonBrowser json) {
        for (JsonBrowser value : json.values()) {
            for (JsonBrowser entry : value.safeGet("data").values()) {
                if (!entry.isMap() || !"playlist".equals(entry.get("kind").text())) continue;
                return entry;
            }
        }
        throw new IllegalStateException("Could not find playlist information block.");
    }

    private List<AudioTrack> loadTracksFromPlaylist(HttpInterface httpInterface, JsonBrowser playlistInfo, String playlistWebUrl) throws IOException {
        List<String> trackIds = this.loadPlaylistTrackList(playlistInfo);
        return this.withClientIdRetry(httpInterface, response -> this.handlePlaylistTracksResponse(response, playlistWebUrl, trackIds), () -> this.buildTrackListUrl(trackIds));
    }

    private List<AudioTrack> handlePlaylistTracksResponse(HttpResponse response, String playlistWebUrl, List<String> trackIds) throws IOException {
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            throw new IOException("Invalid status code for track list response: " + statusCode);
        }
        JsonBrowser trackList = JsonBrowser.parse(response.getEntity().getContent());
        int blockedCount = 0;
        for (JsonBrowser trackInfoJson : trackList.values()) {
            if ("BLOCK".equals(trackInfoJson.get("policy").text())) {
                ++blockedCount;
                continue;
            }
            tracks.add(this.buildAudioTrack(trackInfoJson, null));
        }
        if (blockedCount > 0) {
            log.debug("In soundcloud playlist {}, {} tracks were omitted because they are blocked.", (Object)playlistWebUrl, (Object)blockedCount);
        }
        SoundCloudAudioSourceManager.sortPlaylistTracks(tracks, trackIds);
        return tracks;
    }

    private List<String> loadPlaylistTrackList(JsonBrowser playlistInfo) {
        ArrayList<String> trackIds = new ArrayList<String>();
        for (JsonBrowser trackInfo : playlistInfo.get("tracks").values()) {
            trackIds.add(trackInfo.get("id").text());
        }
        return trackIds;
    }

    private URI buildTrackListUrl(List<String> trackIds) {
        try {
            StringJoiner joiner = new StringJoiner(",");
            for (String trackId : trackIds) {
                joiner.add(trackId);
            }
            return new URIBuilder("https://api-v2.soundcloud.com/tracks").addParameter("ids", joiner.toString()).addParameter("client_id", this.getClientId()).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static void sortPlaylistTracks(List<AudioTrack> tracks, List<String> trackIds) {
        HashMap<String, Integer> positions = new HashMap<String, Integer>();
        for (int i = 0; i < trackIds.size(); ++i) {
            positions.put(trackIds.get(i), i);
        }
        Collections.sort(tracks, Comparator.comparingInt(o -> SoundCloudAudioSourceManager.getSortPosition(positions, o)));
    }

    private static int getSortPosition(Map<String, Integer> positions, AudioTrack track) {
        return DataFormatTools.defaultOnNull(positions.get(track.getIdentifier()), Integer.MAX_VALUE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AudioItem loadFromLikedTracks(String likedListUrl) {
        try (HttpInterface httpInterface = this.getHttpInterface();){
            UserInfo userInfo = this.findUserIdFromLikedList(httpInterface, likedListUrl);
            if (userInfo == null) {
                AudioReference audioReference = AudioReference.NO_TRACK;
                return audioReference;
            }
            AudioItem audioItem = this.extractTracksFromLikedList(this.loadLikedListForUserId(httpInterface, userInfo), userInfo);
            return audioItem;
        }
        catch (IOException e) {
            throw new FriendlyException("Loading liked tracks from SoundCloud failed.", FriendlyException.Severity.SUSPICIOUS, e);
        }
    }

    private UserInfo findUserIdFromLikedList(HttpInterface httpInterface, String likedListUrl) throws IOException {
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(likedListUrl));){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 404) {
                UserInfo userInfo = null;
                return userInfo;
            }
            if (statusCode != 200) {
                throw new IOException("Invalid status code for track list response: " + statusCode);
            }
            Matcher matcher = likedUserUrnPattern.matcher(IOUtils.toString(response.getEntity().getContent(), StandardCharsets.UTF_8));
            UserInfo userInfo = matcher.find() ? new UserInfo(matcher.group(1), matcher.group(2)) : null;
            return userInfo;
        }
    }

    private JsonBrowser loadLikedListForUserId(HttpInterface httpInterface, UserInfo userInfo) throws IOException {
        return this.withClientIdRetry(httpInterface, response -> {
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new IOException("Invalid status code for liked tracks response: " + statusCode);
            }
            return JsonBrowser.parse(response.getEntity().getContent());
        }, () -> new URI("https://api-v2.soundcloud.com/users/" + userInfo.id + "/likes?client_id=" + this.getClientId() + "&limit=200&offset=0"));
    }

    private AudioItem extractTracksFromLikedList(JsonBrowser likedTracks, UserInfo userInfo) {
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (JsonBrowser item : likedTracks.get("collection").values()) {
            JsonBrowser trackItem = item.get("track");
            if (trackItem.isNull()) continue;
            tracks.add(this.buildAudioTrack(trackItem, null));
        }
        return new BasicAudioPlaylist("Liked by " + userInfo.name, tracks, null, false);
    }

    private AudioItem processAsSearchQuery(AudioReference reference) {
        if (reference.identifier.startsWith(SEARCH_PREFIX)) {
            if (reference.identifier.startsWith(SEARCH_PREFIX_DEFAULT)) {
                return this.loadSearchResult(reference.identifier.substring(SEARCH_PREFIX_DEFAULT.length()).trim(), 0, 10);
            }
            Matcher searchMatcher = searchPattern.matcher(reference.identifier);
            if (searchMatcher.matches()) {
                return this.loadSearchResult(searchMatcher.group(3), Integer.parseInt(searchMatcher.group(1)), Integer.parseInt(searchMatcher.group(2)));
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AudioItem loadSearchResult(String query, int offset, int rawLimit) {
        int limit = Math.min(rawLimit, 200);
        try (HttpInterface httpInterface = this.getHttpInterface();){
            AudioItem audioItem = this.withClientIdRetry(httpInterface, response -> this.loadSearchResultsFromResponse(response, query), () -> this.buildSearchUri(query, offset, limit));
            return audioItem;
        }
        catch (IOException e) {
            throw new FriendlyException("Loading search results from SoundCloud failed.", FriendlyException.Severity.SUSPICIOUS, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AudioItem loadSearchResultsFromResponse(HttpResponse response, String query) throws IOException {
        try {
            JsonBrowser searchResults = JsonBrowser.parse(response.getEntity().getContent());
            AudioItem audioItem = this.extractTracksFromSearchResults(query, searchResults);
            return audioItem;
        }
        finally {
            EntityUtils.consumeQuietly(response.getEntity());
        }
    }

    private URI buildSearchUri(String query, int offset, int limit) {
        try {
            return new URIBuilder("https://api-v2.soundcloud.com/search/tracks").addParameter("q", query).addParameter("client_id", this.getClientId()).addParameter("offset", String.valueOf(offset)).addParameter("limit", String.valueOf(limit)).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T withClientIdRetry(HttpInterface httpInterface, ResponseHandler<T> handler, URIProvider uriProvider) throws IOException {
        try {
            CloseableHttpResponse response = httpInterface.execute(new HttpGet(uriProvider.provide()));
            int statusCode = response.getStatusLine().getStatusCode();
            try {
                if (statusCode != 401) {
                    T t = handler.handle(response);
                    return t;
                }
            }
            finally {
                EntityUtils.consumeQuietly(response.getEntity());
            }
            this.updateClientId();
            response = httpInterface.execute(new HttpGet(uriProvider.provide()));
            try {
                T t = handler.handle(response);
                return t;
            }
            finally {
                EntityUtils.consumeQuietly(response.getEntity());
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private AudioItem extractTracksFromSearchResults(String query, JsonBrowser searchResults) {
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (JsonBrowser item : searchResults.get("collection").values()) {
            if (item.isNull()) continue;
            tracks.add(this.buildAudioTrack(item, null));
        }
        return new BasicAudioPlaylist("Search results for: " + query, tracks, null, true);
    }

    private static interface URIProvider {
        public URI provide() throws URISyntaxException;
    }

    private static interface ResponseHandler<T> {
        public T handle(HttpResponse var1) throws IOException;
    }

    private static class UserInfo {
        private final String id;
        private final String name;

        private UserInfo(String id, String name) {
            this.id = id;
            this.name = name;
        }
    }
}

