/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.filter;

import com.sedmelluq.discord.lavaplayer.filter.AudioPostProcessor;
import com.sedmelluq.discord.lavaplayer.format.transcoder.AudioChunkEncoder;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import java.nio.ShortBuffer;

public class BufferingPostProcessor
implements AudioPostProcessor {
    private final AudioProcessingContext context;
    private final AudioChunkEncoder encoder;

    public BufferingPostProcessor(AudioProcessingContext context, AudioChunkEncoder encoder) {
        this.encoder = encoder;
        this.context = context;
    }

    @Override
    public void process(long timecode, ShortBuffer buffer) throws InterruptedException {
        this.context.frameConsumer.consume(new AudioFrame(timecode, this.encoder.encode(buffer), this.context.volumeLevel.get(), this.context.outputFormat));
    }

    @Override
    public void close() {
        this.encoder.close();
    }
}

