/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.mpeg;

import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegTrackConsumer;
import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegTrackInfo;
import com.sedmelluq.discord.lavaplayer.filter.FilterChainBuilder;
import com.sedmelluq.discord.lavaplayer.filter.ShortPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.natives.aac.AacDecoder;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ReadableByteChannel;
import me.iblitzkriegi.vixio.org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MpegAacTrackConsumer
implements MpegTrackConsumer {
    private static final Logger log = LoggerFactory.getLogger(MpegAacTrackConsumer.class);
    private final MpegTrackInfo track;
    private final ByteBuffer inputBuffer;
    private final ShortBuffer outputBuffer;
    private final ShortPcmAudioFilter downstream;
    private AacDecoder decoder;

    public MpegAacTrackConsumer(AudioProcessingContext context, MpegTrackInfo track) {
        this.track = track;
        this.decoder = new AacDecoder();
        this.inputBuffer = ByteBuffer.allocateDirect(4096);
        this.outputBuffer = ByteBuffer.allocateDirect(2048 * track.channelCount).order(ByteOrder.nativeOrder()).asShortBuffer();
        this.downstream = FilterChainBuilder.forShortPcm(context, track.channelCount, track.sampleRate, true);
    }

    @Override
    public void initialise() {
        log.debug("Initialising AAC track with frequency {} and channel count {}.", (Object)this.track.sampleRate, (Object)this.track.channelCount);
        this.decoder.configure(2, this.track.sampleRate, this.track.channelCount);
    }

    @Override
    public MpegTrackInfo getTrack() {
        return this.track;
    }

    @Override
    public void seekPerformed(long requestedTimecode, long providedTimecode) {
        this.downstream.seekPerformed(requestedTimecode, providedTimecode);
        this.decoder.close();
        this.decoder = new AacDecoder();
        this.decoder.configure(2, this.track.sampleRate, this.track.channelCount);
    }

    @Override
    public void flush() throws InterruptedException {
        while (this.decoder.decode(this.outputBuffer, true)) {
            this.downstream.process(this.outputBuffer);
            this.outputBuffer.clear();
        }
    }

    @Override
    public void consume(ReadableByteChannel channel, int length) throws InterruptedException {
        int chunk;
        for (int remaining = length; remaining > 0; remaining -= chunk) {
            chunk = Math.min(remaining, this.inputBuffer.capacity());
            this.inputBuffer.clear();
            this.inputBuffer.limit(chunk);
            try {
                IOUtils.readFully(channel, this.inputBuffer);
            }
            catch (ClosedByInterruptException e) {
                log.trace("Interrupt received while reading channel", e);
                Thread.currentThread().interrupt();
                throw new InterruptedException();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.inputBuffer.flip();
            this.decoder.fill(this.inputBuffer);
            while (this.decoder.decode(this.outputBuffer, false)) {
                this.downstream.process(this.outputBuffer);
                this.outputBuffer.clear();
            }
        }
    }

    @Override
    public void close() {
        this.downstream.close();
        this.decoder.close();
    }
}

