/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.utils;

import gnu.trove.TCollections;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Formatter;
import java.util.TimeZone;
import me.iblitzkriegi.vixio.org.apache.commons.lang3.StringUtils;
import me.iblitzkriegi.vixio.org.apache.http.util.Args;
import net.dv8tion.jda.core.entities.ISnowflake;

public class MiscUtil {
    public static final long DISCORD_EPOCH = 1420070400000L;
    public static final long TIMESTAMP_OFFSET = 22L;
    private static final DateTimeFormatter dtFormatter = DateTimeFormatter.RFC_1123_DATE_TIME;

    public static OffsetDateTime getCreationTime(long entityId) {
        try {
            long timestamp = (entityId >> 22) + 1420070400000L;
            Calendar gmt = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            gmt.setTimeInMillis(timestamp);
            return OffsetDateTime.ofInstant(gmt.toInstant(), gmt.getTimeZone().toZoneId());
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    public static OffsetDateTime getCreationTime(ISnowflake entity) {
        Args.notNull(entity, "Entity");
        return MiscUtil.getCreationTime(entity.getIdLong());
    }

    public static String getDateTimeString(OffsetDateTime time) {
        return time.format(dtFormatter);
    }

    public static <T> TLongObjectMap<T> newLongMap() {
        return TCollections.synchronizedMap(new TLongObjectHashMap());
    }

    public static String encodeUTF8(String chars) {
        try {
            return URLEncoder.encode(chars, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static long parseSnowflake(String input) {
        Args.notEmpty(input, "ID");
        try {
            return Long.parseLong(input.trim());
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException(String.format("The specified ID is not a valid snowflake (%s). Expecting a valid long value!", input));
        }
    }

    public static void appendTo(Formatter formatter, int width, int precision, boolean leftJustified, String out) {
        try {
            Appendable appendable = formatter.out();
            if (precision > -1 && out.length() > precision) {
                appendable.append(StringUtils.truncate(out, precision));
                return;
            }
            if (leftJustified) {
                appendable.append(StringUtils.rightPad(out, width));
            } else {
                appendable.append(StringUtils.leftPad(out, width));
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

