/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests.restaction.pagination;

import java.util.LinkedList;
import java.util.List;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.MessageReaction;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.restaction.pagination.PaginationAction;
import net.dv8tion.jda.core.utils.MiscUtil;
import org.json.JSONArray;

public class ReactionPaginationAction
extends PaginationAction<User, ReactionPaginationAction> {
    protected final MessageReaction reaction;
    protected final String code;

    public ReactionPaginationAction(MessageReaction reaction) {
        super(reaction.getJDA(), 1, 100, 100);
        this.reaction = reaction;
        MessageReaction.ReactionEmote emote = reaction.getEmote();
        this.code = emote.isEmote() ? emote.getName() + ":" + emote.getId() : MiscUtil.encodeUTF8(emote.getName());
    }

    public MessageReaction getReaction() {
        return this.reaction;
    }

    @Override
    protected void finalizeRoute() {
        String after = null;
        String limit = String.valueOf(this.getLimit());
        if (!this.isEmpty()) {
            after = ((User)this.getLast()).getId();
        }
        String channel = this.reaction.getChannel().getId();
        String message = this.reaction.getMessageId();
        this.route = after != null ? Route.Messages.GET_REACTION_USERS_AFTER.compile(channel, message, this.code, limit, after) : Route.Messages.GET_REACTION_USERS_LIMIT.compile(channel, message, this.code, limit);
    }

    @Override
    protected void handleResponse(Response response, Request<List<User>> request) {
        if (!response.isOk()) {
            request.onFailure(response);
            return;
        }
        EntityBuilder builder = this.api.getEntityBuilder();
        JSONArray array = response.getArray();
        LinkedList<User> users = new LinkedList<User>();
        for (int i = 0; i < array.length(); ++i) {
            User user = builder.createFakeUser(array.getJSONObject(i), false);
            this.cached.add(user);
            users.add(user);
        }
        request.onSuccess(users);
    }
}

