/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests.restaction.pagination;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import me.iblitzkriegi.vixio.org.apache.http.util.Args;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;

public abstract class PaginationAction<T, M extends PaginationAction<T, M>>
extends RestAction<List<T>>
implements Iterable<T> {
    protected final List<T> cached = new CopyOnWriteArrayList<T>();
    protected final int maxLimit;
    protected final int minLimit;
    protected final AtomicInteger limit;

    public PaginationAction(JDA api, int minLimit, int maxLimit, int initialLimit) {
        super(api, null, null);
        this.maxLimit = maxLimit;
        this.minLimit = minLimit;
        this.limit = new AtomicInteger(initialLimit);
    }

    public PaginationAction(JDA api) {
        super(api, null, null);
        this.maxLimit = 0;
        this.minLimit = 0;
        this.limit = new AtomicInteger(0);
    }

    public int cacheSize() {
        return this.cached.size();
    }

    public boolean isEmpty() {
        return this.cached.isEmpty();
    }

    public List<T> getCached() {
        return Collections.unmodifiableList(this.cached);
    }

    public T getLast() {
        if (this.cached.isEmpty()) {
            throw new NoSuchElementException("No entities have been retrieved yet.");
        }
        return this.cached.get(this.cached.size() - 1);
    }

    public T getFirst() {
        if (this.cached.isEmpty()) {
            throw new NoSuchElementException("No entities have been retrieved yet.");
        }
        return this.cached.get(0);
    }

    public M limit(int limit) {
        Args.check(this.maxLimit == 0 || limit <= this.maxLimit, "Limit must not exceed %d!", (Object)this.maxLimit);
        Args.check(this.minLimit == 0 || limit >= this.minLimit, "Limit must be greater or equal to %d", (Object)this.minLimit);
        this.limit.set(limit);
        return (M)this;
    }

    public final int getMaxLimit() {
        return this.maxLimit;
    }

    public final int getMinLimit() {
        return this.minLimit;
    }

    public final int getLimit() {
        return this.limit.get();
    }

    public PaginationIterator iterator() {
        return new PaginationIterator();
    }

    @Override
    public Spliterator<T> spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 1024);
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Stream<T> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    @Override
    protected abstract void finalizeRoute();

    @Override
    protected abstract void handleResponse(Response var1, Request<List<T>> var2);

    public class PaginationIterator
    implements Iterator<T> {
        protected int current = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            if (this.current < 0) {
                return false;
            }
            if (this.hitEnd()) {
                AtomicInteger atomicInteger = PaginationAction.this.limit;
                synchronized (atomicInteger) {
                    int tmp = PaginationAction.this.limit.getAndSet(PaginationAction.this.maxLimit);
                    PaginationAction.this.complete();
                    PaginationAction.this.limit.set(tmp);
                }
                if (!this.hitEnd()) {
                    return true;
                }
                this.current = -1;
                return false;
            }
            return true;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Reached End of pagination task!");
            }
            return PaginationAction.this.cached.get(this.current++);
        }

        protected boolean hitEnd() {
            return this.current < 0 || this.current >= PaginationAction.this.cached.size();
        }
    }
}

