/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests.restaction.order;

import java.util.List;
import me.iblitzkriegi.vixio.org.apache.http.util.Args;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.exceptions.PermissionException;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.restaction.order.OrderAction;
import org.json.JSONArray;
import org.json.JSONObject;

public class ChannelOrderAction<T extends Channel>
extends OrderAction<T, ChannelOrderAction<T>> {
    protected final Guild guild;
    protected final ChannelType type;

    public ChannelOrderAction(Guild guild, ChannelType type) {
        super(guild.getJDA(), Route.Guilds.MODIFY_CHANNELS.compile(guild.getId()));
        this.guild = guild;
        this.type = type;
        List<Comparable<TextChannel>> chans = type == ChannelType.TEXT ? guild.getTextChannels() : guild.getVoiceChannels();
        this.orderList.addAll(chans);
    }

    public Guild getGuild() {
        return this.guild;
    }

    public ChannelType getChannelType() {
        return this.type;
    }

    @Override
    protected void finalizeData() {
        Member self = this.guild.getSelfMember();
        if (!self.hasPermission(Permission.MANAGE_CHANNEL)) {
            throw new PermissionException(Permission.MANAGE_CHANNEL);
        }
        JSONArray array = new JSONArray();
        for (int i = 0; i < this.orderList.size(); ++i) {
            Channel chan = (Channel)this.orderList.get(i);
            array.put(new JSONObject().put("id", chan.getId()).put("position", i));
        }
        this.data = array;
    }

    @Override
    protected void validateInput(T entity) {
        Args.check(entity.getGuild().equals(this.guild), "Provided channel is not from this Guild!");
        Args.check(this.orderList.contains(entity), "Provided channel is not in the list of orderable channels!");
    }
}

