/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests.restaction;

import me.iblitzkriegi.vixio.org.apache.http.util.Args;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.Icon;
import net.dv8tion.jda.core.entities.Webhook;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import org.json.JSONObject;

public class WebhookAction
extends RestAction<Webhook> {
    protected String name;
    protected Icon avatar = null;

    public WebhookAction(JDA api, Route.CompiledRoute route, String name) {
        super(api, route, null);
        this.name = name;
    }

    public WebhookAction setName(String name) {
        Args.notNull(name, "Webhook name");
        if (name.length() < 2 || name.length() > 100) {
            throw new IllegalArgumentException("The webhook name must be in the range of 2-100!");
        }
        this.name = name;
        return this;
    }

    public WebhookAction setAvatar(Icon icon) {
        this.avatar = icon;
        return this;
    }

    @Override
    public void finalizeData() {
        JSONObject data = new JSONObject();
        data.put("name", this.name);
        data.put("avatar", this.avatar != null ? this.avatar.getEncoding() : JSONObject.NULL);
        this.data = data;
    }

    @Override
    protected void handleResponse(Response response, Request<Webhook> request) {
        if (!response.isOk()) {
            request.onFailure(response);
            return;
        }
        JSONObject json = response.getObject();
        Webhook webhook = this.api.getEntityBuilder().createWebhook(json);
        request.onSuccess(webhook);
    }
}

