/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests.restaction;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.iblitzkriegi.vixio.org.apache.http.util.Args;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.PermissionOverride;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.impl.PermissionOverrideImpl;
import net.dv8tion.jda.core.entities.impl.TextChannelImpl;
import net.dv8tion.jda.core.entities.impl.VoiceChannelImpl;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import org.json.JSONObject;

public class PermissionOverrideAction
extends RestAction<PermissionOverride> {
    private long allow = 0L;
    private long deny = 0L;
    private final Channel channel;
    private final Member member;
    private final Role role;

    public PermissionOverrideAction(JDA api, Route.CompiledRoute route, Channel channel, Member member) {
        super(api, route, null);
        this.channel = channel;
        this.member = member;
        this.role = null;
    }

    public PermissionOverrideAction(JDA api, Route.CompiledRoute route, Channel channel, Role role) {
        super(api, route, null);
        this.channel = channel;
        this.member = null;
        this.role = role;
    }

    public long getAllow() {
        return this.allow;
    }

    public List<Permission> getAllowedPermissions() {
        return Collections.unmodifiableList(Permission.getPermissions(this.allow));
    }

    public long getDeny() {
        return this.deny;
    }

    public List<Permission> getDeniedPermissions() {
        return Collections.unmodifiableList(Permission.getPermissions(this.deny));
    }

    public long getInherited() {
        return (this.allow ^ 0xFFFFFFFFFFFFFFFFL) & (this.deny ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public List<Permission> getInheritedPermissions() {
        return Permission.getPermissions(this.getInherited());
    }

    public boolean isMember() {
        return this.member != null;
    }

    public boolean isRole() {
        return this.role != null;
    }

    public PermissionOverrideAction setAllow(long allowBits) {
        Args.notNegative(allowBits, "Granted permissions value");
        Args.check(allowBits <= Permission.ALL_PERMISSIONS, "Specified allow value may not be greater than a full permission set");
        this.allow = allowBits;
        return this;
    }

    public PermissionOverrideAction setAllow(Collection<Permission> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return this.setAllow(0L);
        }
        this.checkNull(permissions, "Permission");
        return this.setAllow(Permission.getRaw(permissions));
    }

    public PermissionOverrideAction setAllow(Permission ... permissions) {
        if (permissions == null || permissions.length < 1) {
            return this.setAllow(0L);
        }
        this.checkNull(permissions, "Permission");
        return this.setAllow(Permission.getRaw(permissions));
    }

    public PermissionOverrideAction setDeny(long denyBits) {
        Args.notNegative(denyBits, "Denied permissions value");
        Args.check(denyBits <= Permission.ALL_PERMISSIONS, "Specified allow value may not be greater than a full permission set");
        this.deny = denyBits;
        return this;
    }

    public PermissionOverrideAction setDeny(Collection<Permission> permissions) {
        if (permissions == null || permissions.isEmpty()) {
            return this.setDeny(0L);
        }
        this.checkNull(permissions, "Permission");
        return this.setDeny(Permission.getRaw(permissions));
    }

    public PermissionOverrideAction setDeny(Permission ... permissions) {
        if (permissions == null || permissions.length < 1) {
            return this.setDeny(0L);
        }
        this.checkNull(permissions, "Permission");
        return this.setDeny(Permission.getRaw(permissions));
    }

    public PermissionOverrideAction setPermissions(long allowBits, long denyBits) {
        this.setAllow(allowBits);
        this.setDeny(denyBits);
        return this;
    }

    public PermissionOverrideAction setPermissions(Collection<Permission> grantPermissions, Collection<Permission> denyPermissions) {
        this.setAllow(grantPermissions);
        this.setDeny(denyPermissions);
        return this;
    }

    @Override
    protected void finalizeData() {
        JSONObject object = new JSONObject();
        object.put("type", this.isRole() ? "role" : "member");
        object.put("allow", this.allow);
        object.put("deny", this.deny);
        this.data = object;
        super.finalizeData();
    }

    @Override
    protected void handleResponse(Response response, Request<PermissionOverride> request) {
        if (!response.isOk()) {
            request.onFailure(response);
            return;
        }
        JSONObject object = response.getObject();
        PermissionOverrideImpl override = new PermissionOverrideImpl(this.channel, this.member, this.role).setAllow(this.allow).setDeny(this.deny);
        boolean isText = this.channel instanceof TextChannelImpl;
        if (this.isMember()) {
            if (isText) {
                ((TextChannelImpl)this.channel).getMemberOverrideMap().put(this.member, override);
            } else {
                ((VoiceChannelImpl)this.channel).getMemberOverrideMap().put(this.member, override);
            }
        } else if (isText) {
            ((TextChannelImpl)this.channel).getRoleOverrideMap().put(this.role, override);
        } else {
            ((VoiceChannelImpl)this.channel).getRoleOverrideMap().put(this.role, override);
        }
        request.onSuccess(override);
    }

    private void checkNull(Collection<?> collection, String name) {
        Args.notNull(collection, name);
        collection.forEach(e -> Args.notNull(e, name));
    }

    private <T> void checkNull(T[] arr, String name) {
        Args.notNull(arr, name);
        for (T e : arr) {
            Args.notNull(e, name);
        }
    }
}

