/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests.restaction;

import java.util.concurrent.TimeUnit;
import me.iblitzkriegi.vixio.org.apache.http.util.Args;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.Invite;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import org.json.JSONObject;

public class InviteAction
extends RestAction<Invite> {
    private Integer maxAge = null;
    private Integer maxUses = null;
    private Boolean temporary = null;
    private Boolean unique = null;

    public InviteAction(JDA api, String channelId) {
        super(api, Route.Invites.CREATE_INVITE.compile(channelId), null);
    }

    @Override
    protected void finalizeData() {
        JSONObject object = new JSONObject();
        if (this.maxAge != null) {
            object.put("max_age", this.maxAge);
        }
        if (this.maxUses != null) {
            object.put("max_uses", this.maxUses);
        }
        if (this.temporary != null) {
            object.put("temporary", this.temporary);
        }
        if (this.unique != null) {
            object.put("unique", this.unique);
        }
        this.data = object;
    }

    @Override
    protected void handleResponse(Response response, Request<Invite> request) {
        if (response.isOk()) {
            request.onSuccess(this.api.getEntityBuilder().createInvite(response.getObject()));
        } else {
            request.onFailure(response);
        }
    }

    public final InviteAction setMaxAge(Integer maxAge) {
        if (maxAge != null) {
            Args.notNegative(maxAge, "maxAge");
        }
        this.maxAge = maxAge;
        return this;
    }

    public final InviteAction setMaxAge(Long maxAge, TimeUnit timeUnit) {
        if (maxAge == null) {
            return this.setMaxAge(null);
        }
        Args.notNegative(maxAge, "maxAge");
        Args.notNull(timeUnit, "timeUnit");
        return this.setMaxAge(Math.toIntExact(timeUnit.toSeconds(maxAge)));
    }

    public final InviteAction setMaxUses(Integer maxUses) {
        if (maxUses != null) {
            Args.notNegative(maxUses, "maxUses");
        }
        this.maxUses = maxUses;
        return this;
    }

    public final InviteAction setTemporary(Boolean temporary) {
        this.temporary = temporary;
        return this;
    }

    public final InviteAction setUnique(Boolean unique) {
        this.unique = unique;
        return this;
    }
}

