/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import me.iblitzkriegi.vixio.org.apache.http.util.Args;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.exceptions.ErrorResponseException;
import net.dv8tion.jda.core.exceptions.PermissionException;
import net.dv8tion.jda.core.exceptions.RateLimitedException;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.restaction.CompletedFuture;
import net.dv8tion.jda.core.requests.restaction.RequestFuture;
import net.dv8tion.jda.core.utils.SimpleLog;

public abstract class RestAction<T> {
    public static final SimpleLog LOG = SimpleLog.getLog("RestAction");
    public static Consumer DEFAULT_SUCCESS = o -> {};
    public static Consumer<Throwable> DEFAULT_FAILURE = t -> {
        if (LOG.getEffectiveLevel().getPriority() <= SimpleLog.Level.DEBUG.getPriority()) {
            LOG.log((Throwable)t);
        } else {
            LOG.fatal("RestAction queue returned failure: [" + t.getClass().getSimpleName() + "] " + t.getMessage());
        }
    };
    protected final JDAImpl api;
    protected Route.CompiledRoute route;
    protected Object data;

    public RestAction(JDA api, Route.CompiledRoute route, Object data) {
        this.api = (JDAImpl)api;
        this.route = route;
        this.data = data != null ? data : "";
    }

    public JDA getJDA() {
        return this.api;
    }

    public void queue() {
        this.queue(null, null);
    }

    public void queue(Consumer<T> success) {
        this.queue(success, null);
    }

    public void queue(Consumer<T> success, Consumer<Throwable> failure) {
        this.finalizeData();
        this.finalizeRoute();
        if (success == null) {
            success = DEFAULT_SUCCESS;
        }
        if (failure == null) {
            failure = DEFAULT_FAILURE;
        }
        this.api.getRequester().request(new Request(this, success, failure, true));
    }

    public Future<T> submit() {
        return this.submit(true);
    }

    public Future<T> submit(boolean shouldQueue) {
        this.finalizeData();
        this.finalizeRoute();
        return new RequestFuture(this, shouldQueue);
    }

    public T complete() {
        try {
            return this.complete(true);
        }
        catch (RateLimitedException ignored) {
            throw new RuntimeException(ignored);
        }
    }

    public T complete(boolean shouldQueue) throws RateLimitedException {
        try {
            return this.submit(shouldQueue).get();
        }
        catch (Throwable e) {
            if (e instanceof ExecutionException) {
                Throwable t = e.getCause();
                if (t instanceof RateLimitedException) {
                    throw (RateLimitedException)t;
                }
                if (t instanceof PermissionException) {
                    throw (PermissionException)t;
                }
                if (t instanceof ErrorResponseException) {
                    throw (ErrorResponseException)t;
                }
            }
            throw new RuntimeException(e);
        }
    }

    public ScheduledFuture<T> submitAfter(long delay, TimeUnit unit) {
        return this.submitAfter(delay, unit, this.api.pool);
    }

    public ScheduledFuture<T> submitAfter(long delay, TimeUnit unit, ScheduledExecutorService executor) {
        Args.notNull(executor, "Scheduler");
        Args.notNull(unit, "TimeUnit");
        return executor.schedule(this::complete, delay, unit);
    }

    public T completeAfter(long delay, TimeUnit unit) {
        Args.notNull(unit, "TimeUnit");
        try {
            unit.sleep(delay);
            return this.complete();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public ScheduledFuture<?> queueAfter(long delay, TimeUnit unit) {
        return this.queueAfter(delay, unit, this.api.pool);
    }

    public ScheduledFuture<?> queueAfter(long delay, TimeUnit unit, Consumer<T> success) {
        return this.queueAfter(delay, unit, success, this.api.pool);
    }

    public ScheduledFuture<?> queueAfter(long delay, TimeUnit unit, Consumer<T> success, Consumer<Throwable> failure) {
        return this.queueAfter(delay, unit, success, failure, this.api.pool);
    }

    public ScheduledFuture<?> queueAfter(long delay, TimeUnit unit, ScheduledExecutorService executor) {
        return this.queueAfter(delay, unit, null, executor);
    }

    public ScheduledFuture<?> queueAfter(long delay, TimeUnit unit, Consumer<T> success, ScheduledExecutorService executor) {
        return this.queueAfter(delay, unit, success, null, executor);
    }

    public ScheduledFuture<?> queueAfter(long delay, TimeUnit unit, Consumer<T> success, Consumer<Throwable> failure, ScheduledExecutorService executor) {
        Args.notNull(executor, "Scheduler");
        Args.notNull(unit, "TimeUnit");
        return executor.schedule(() -> this.queue(success, failure), delay, unit);
    }

    protected void finalizeData() {
    }

    protected void finalizeRoute() {
    }

    protected abstract void handleResponse(Response var1, Request<T> var2);

    public static class EmptyRestAction<T>
    extends RestAction<T> {
        private final T returnObj;

        public EmptyRestAction(T returnObj) {
            super(null, null, null);
            this.returnObj = returnObj;
        }

        @Override
        public void queue(Consumer<T> success, Consumer<Throwable> failure) {
            if (success != null) {
                success.accept(this.returnObj);
            }
        }

        @Override
        public Future<T> submit(boolean shouldQueue) {
            return new CompletedFuture<T>(this.returnObj);
        }

        @Override
        public T complete(boolean shouldQueue) {
            return this.returnObj;
        }

        @Override
        protected void handleResponse(Response response, Request<T> request) {
        }
    }
}

