/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.BaseRequest;
import com.mashape.unirest.request.GetRequest;
import com.mashape.unirest.request.HttpRequest;
import com.mashape.unirest.request.body.MultipartBody;
import java.util.LinkedHashSet;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.JDAInfo;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.requests.RateLimiter;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.ratelimit.BotRateLimiter;
import net.dv8tion.jda.core.requests.ratelimit.ClientRateLimiter;
import net.dv8tion.jda.core.utils.SimpleLog;

public class Requester {
    public static final SimpleLog LOG = SimpleLog.getLog("JDARequester");
    public static final String DISCORD_API_PREFIX = "https://discordapp.com/api/";
    public static String USER_AGENT = "JDA DiscordBot (https://github.com/DV8FromTheWorld/JDA, " + JDAInfo.VERSION + ")";
    private final JDAImpl api;
    private final RateLimiter rateLimiter;

    public Requester(JDA api) {
        this(api, api.getAccountType());
    }

    public Requester(JDA api, AccountType accountType) {
        if (accountType == null) {
            throw new NullPointerException("Provided accountType was null!");
        }
        this.api = (JDAImpl)api;
        this.rateLimiter = accountType == AccountType.BOT ? new BotRateLimiter(this, 5) : new ClientRateLimiter(this, 5);
    }

    public JDAImpl getJDA() {
        return this.api;
    }

    public <T> void request(Request<T> apiRequest) {
        if (this.rateLimiter.isShutdown) {
            throw new IllegalStateException("The Requester has been shutdown! No new requests can be requested!");
        }
        if (apiRequest.shouldQueue()) {
            this.rateLimiter.queueRequest(apiRequest);
        } else {
            Long retryAfter = this.execute(apiRequest);
            if (retryAfter != null) {
                apiRequest.getRestAction().handleResponse(new Response(429, null, retryAfter), apiRequest);
            }
        }
    }

    public <T> Long execute(Request<T> apiRequest) {
        BaseRequest request;
        Route.CompiledRoute route = apiRequest.getRoute();
        Long retryAfter = this.rateLimiter.getRateLimit(route);
        if (retryAfter != null) {
            return retryAfter;
        }
        Object body = apiRequest.getData();
        if (body instanceof MultipartBody) {
            request = this.addHeaders((MultipartBody)body);
        } else {
            String bodyData = body != null ? body.toString() : null;
            request = this.createRequest(route, bodyData);
        }
        LinkedHashSet<String> rays = new LinkedHashSet<String>();
        try {
            HttpResponse<String> response;
            int attempt = 0;
            do {
                if (apiRequest.isCanceled()) {
                    return null;
                }
                response = request.asString();
                String cfRay = response.getHeaders().getFirst("CF-RAY");
                if (cfRay != null) {
                    rays.add(cfRay);
                }
                if (response.getStatus() < 500) break;
                LOG.debug(String.format("Requesting %s -> %s returned status %d... retrying (attempt %d)", request.getHttpRequest().getHttpMethod().name(), request.getHttpRequest().getUrl(), response.getStatus(), ++attempt));
                try {
                    Thread.sleep(50 * attempt);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (attempt < 3 && response.getStatus() >= 500);
            if (response.getStatus() >= 500) {
                return null;
            }
            retryAfter = this.rateLimiter.handleResponse(route, response);
            if (!rays.isEmpty()) {
                LOG.debug("Received response with following cf-rays: " + rays);
            }
            if (retryAfter == null) {
                apiRequest.getRestAction().handleResponse(new Response(response.getStatus(), response.getBody(), -1L), apiRequest);
            }
            return retryAfter;
        }
        catch (UnirestException e) {
            LOG.log(e);
            apiRequest.getRestAction().handleResponse(new Response(e), apiRequest);
            return null;
        }
    }

    public RateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public void shutdown() {
        this.rateLimiter.shutdown();
    }

    private BaseRequest createRequest(Route.CompiledRoute route, String body) {
        String url = DISCORD_API_PREFIX + route.getCompiledRoute();
        BaseRequest request = null;
        switch (route.getMethod()) {
            case GET: {
                request = this.addHeaders(Unirest.get(url));
                break;
            }
            case POST: {
                request = this.addHeaders(Unirest.post(url)).body(body);
                break;
            }
            case PUT: {
                request = this.addHeaders(Unirest.put(url)).body(body);
                break;
            }
            case DELETE: {
                request = this.addHeaders(Unirest.delete(url));
                break;
            }
            case PATCH: {
                request = this.addHeaders(Unirest.patch(url)).body(body);
            }
        }
        return request;
    }

    protected <T extends BaseRequest> T addHeaders(T baseRequest) {
        HttpRequest request = baseRequest.getHttpRequest();
        if (this.api.getToken() != null && request.getUrl().contains("discordapp.com")) {
            request.header("authorization", this.api.getToken());
        }
        if (!(request instanceof GetRequest) && !(baseRequest instanceof MultipartBody)) {
            request.header("Content-Type", "application/json");
        }
        request.header("user-agent", USER_AGENT);
        request.header("Accept-Encoding", "gzip");
        return baseRequest;
    }
}

