/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests;

import java.util.function.Consumer;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.events.ExceptionEvent;
import net.dv8tion.jda.core.exceptions.ErrorResponseException;
import net.dv8tion.jda.core.exceptions.RateLimitedException;
import net.dv8tion.jda.core.requests.ErrorResponse;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;

public class Request<T> {
    private final JDAImpl api;
    private final RestAction<T> restAction;
    private final Object data;
    private final Consumer<T> onSuccess;
    private final Consumer<Throwable> onFailure;
    private final boolean shouldQueue;
    private boolean isCanceled = false;

    public Request(RestAction<T> restAction, Consumer<T> onSuccess, Consumer<Throwable> onFailure, boolean shouldQueue) {
        this.restAction = restAction;
        this.data = restAction.data;
        this.onSuccess = onSuccess;
        this.onFailure = onFailure;
        this.shouldQueue = shouldQueue;
        this.api = (JDAImpl)restAction.getJDA();
    }

    public void onSuccess(T successObj) {
        this.api.pool.execute(() -> {
            block2: {
                try {
                    this.onSuccess.accept(successObj);
                }
                catch (Throwable t) {
                    RestAction.LOG.fatal("Encountered error while processing success consumer");
                    RestAction.LOG.log(t);
                    if (!(t instanceof Error)) break block2;
                    this.api.getEventManager().handle(new ExceptionEvent(this.api, t, true));
                }
            }
        });
    }

    public void onFailure(Response response) {
        if (response.code == 429) {
            this.onFailure(new RateLimitedException(this.getRoute(), response.retryAfter));
        } else {
            this.onFailure(ErrorResponseException.create(ErrorResponse.fromJSON(response.getObject()), response));
        }
    }

    public void onFailure(Throwable failException) {
        this.api.pool.execute(() -> {
            block3: {
                try {
                    this.onFailure.accept(failException);
                    if (failException instanceof Error) {
                        this.api.getEventManager().handle(new ExceptionEvent(this.api, failException, false));
                    }
                }
                catch (Throwable t) {
                    RestAction.LOG.fatal("Encountered error while processing failure consumer");
                    RestAction.LOG.log(t);
                    if (!(t instanceof Error)) break block3;
                    this.api.getEventManager().handle(new ExceptionEvent(this.api, t, true));
                }
            }
        });
    }

    public RestAction<T> getRestAction() {
        return this.restAction;
    }

    public Consumer<T> getOnSuccess() {
        return this.onSuccess;
    }

    public Consumer<Throwable> getOnFailure() {
        return this.onFailure;
    }

    public Route.CompiledRoute getRoute() {
        return this.restAction.route;
    }

    public Object getData() {
        return this.data;
    }

    public boolean shouldQueue() {
        return this.shouldQueue;
    }

    public void cancel() {
        this.isCanceled = true;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }
}

