/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.managers;

import java.util.Arrays;
import java.util.Collection;
import me.iblitzkriegi.vixio.org.apache.http.util.Args;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.PermissionOverride;
import net.dv8tion.jda.core.exceptions.PermissionException;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import org.json.JSONObject;

public class PermOverrideManagerUpdatable {
    protected final PermissionOverride override;
    protected Long allow;
    protected Long deny;
    protected boolean set;

    public PermOverrideManagerUpdatable(PermissionOverride override) {
        this.override = override;
    }

    public JDA getJDA() {
        return this.override.getJDA();
    }

    public Guild getGuild() {
        return this.override.getGuild();
    }

    public Channel getChannel() {
        return this.override.getChannel();
    }

    public PermissionOverride getPermissionOverride() {
        return this.override;
    }

    public PermOverrideManagerUpdatable grant(long permissions) {
        return this.grant(Permission.getPermissions(permissions));
    }

    public PermOverrideManagerUpdatable grant(Permission ... permissions) {
        return this.grant(Arrays.asList(permissions));
    }

    public PermOverrideManagerUpdatable grant(Collection<Permission> permissions) {
        Args.notNull(permissions, "Permission Collection");
        permissions.forEach(perm -> Args.notNull(perm, "Permission in Permission Collection"));
        this.setupValues();
        long allowBits = Permission.getRaw(permissions);
        this.allow = this.allow | allowBits;
        this.deny = this.deny & (allowBits ^ 0xFFFFFFFFFFFFFFFFL);
        return this;
    }

    public PermOverrideManagerUpdatable deny(long permissions) {
        return this.deny(Permission.getPermissions(permissions));
    }

    public PermOverrideManagerUpdatable deny(Permission ... permissions) {
        return this.deny(Arrays.asList(permissions));
    }

    public PermOverrideManagerUpdatable deny(Collection<Permission> permissions) {
        Args.notNull(permissions, "Permission Collection");
        permissions.forEach(perm -> Args.notNull(perm, "Permission in Permission Collection"));
        this.setupValues();
        long denyBits = Permission.getRaw(permissions);
        this.allow = this.allow & (denyBits ^ 0xFFFFFFFFFFFFFFFFL);
        this.deny = this.deny | denyBits;
        return this;
    }

    public PermOverrideManagerUpdatable clear(long permission) {
        return this.clear(Permission.getPermissions(permission));
    }

    public PermOverrideManagerUpdatable clear(Permission ... permissions) {
        return this.clear(Arrays.asList(permissions));
    }

    public PermOverrideManagerUpdatable clear(Collection<Permission> permissions) {
        Args.notNull(permissions, "Permission Collection");
        permissions.forEach(perm -> Args.notNull(perm, "Permission in Permission Collection"));
        this.setupValues();
        long clearBits = Permission.getRaw(permissions);
        this.allow = this.allow & (clearBits ^ 0xFFFFFFFFFFFFFFFFL);
        this.deny = this.deny & (clearBits ^ 0xFFFFFFFFFFFFFFFFL);
        return this;
    }

    public Long getAllowBits() {
        return this.allow;
    }

    public Long getDenyBits() {
        return this.deny;
    }

    public Long getInheritBits() {
        if (!this.set) {
            return null;
        }
        long maxPerms = 0L;
        for (Permission perm : Permission.values()) {
            if ((long)perm.getOffset() <= maxPerms) continue;
            maxPerms = perm.getOffset();
        }
        maxPerms = ~(1 << (int)(maxPerms + 1L));
        return (this.allow ^ 0xFFFFFFFFFFFFFFFFL | this.deny ^ 0xFFFFFFFFFFFFFFFFL) & maxPerms;
    }

    public boolean isSet() {
        return this.set;
    }

    public void reset() {
        this.set = false;
        this.allow = null;
        this.deny = null;
    }

    public RestAction<Void> update() {
        this.checkPermission(Permission.MANAGE_PERMISSIONS);
        if (!this.shouldUpdate()) {
            return new RestAction.EmptyRestAction<Object>(null);
        }
        String targetId = this.override.isRoleOverride() ? this.override.getRole().getId() : this.override.getMember().getUser().getId();
        JSONObject body = new JSONObject().put("id", targetId).put("type", this.override.isRoleOverride() ? "role" : "member").put("allow", this.getAllowBits()).put("deny", this.getDenyBits());
        this.reset();
        Route.CompiledRoute route = Route.Channels.MODIFY_PERM_OVERRIDE.compile(this.override.getChannel().getId(), targetId);
        return new RestAction<Void>(this.getJDA(), route, (Object)body){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    protected boolean shouldUpdate() {
        return this.set && (this.allow.longValue() != this.override.getAllowedRaw() || this.deny.longValue() != this.override.getDeniedRaw());
    }

    protected void setupValues() {
        if (!this.set) {
            this.set = true;
            this.allow = this.override.getAllowedRaw();
            this.deny = this.override.getDeniedRaw();
        }
    }

    protected void checkPermission(Permission perm) {
        if (!this.getGuild().getSelfMember().hasPermission(this.getChannel(), perm)) {
            throw new PermissionException(perm);
        }
    }
}

