/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import me.iblitzkriegi.vixio.org.apache.commons.lang3.StringUtils;
import net.dv8tion.jda.core.OnlineStatus;
import net.dv8tion.jda.core.entities.Game;
import net.dv8tion.jda.core.entities.impl.GameImpl;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.entities.impl.MemberImpl;
import net.dv8tion.jda.core.entities.impl.UserImpl;
import net.dv8tion.jda.core.events.user.UserAvatarUpdateEvent;
import net.dv8tion.jda.core.events.user.UserGameUpdateEvent;
import net.dv8tion.jda.core.events.user.UserNameUpdateEvent;
import net.dv8tion.jda.core.events.user.UserOnlineStatusUpdateEvent;
import net.dv8tion.jda.core.handle.SocketHandler;
import org.json.JSONObject;

public class PresenceUpdateHandler
extends SocketHandler {
    public PresenceUpdateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        if (content.has("guild_id")) {
            long guildId = content.getLong("guild_id");
            if (this.api.getGuildLock().isLocked(guildId)) {
                return guildId;
            }
        }
        JSONObject jsonUser = content.getJSONObject("user");
        long userId = jsonUser.getLong("id");
        UserImpl user = (UserImpl)this.api.getUserMap().get(userId);
        if (user != null) {
            if (jsonUser.has("username")) {
                String avatarId;
                String name = jsonUser.getString("username");
                String discriminator = jsonUser.get("discriminator").toString();
                String string = avatarId = jsonUser.isNull("avatar") ? null : jsonUser.getString("avatar");
                if (!user.getName().equals(name)) {
                    String oldUsername = user.getName();
                    String oldDiscriminator = user.getDiscriminator();
                    user.setName(name);
                    user.setDiscriminator(discriminator);
                    this.api.getEventManager().handle(new UserNameUpdateEvent(this.api, this.responseNumber, user, oldUsername, oldDiscriminator));
                }
                String oldAvatar = user.getAvatarId();
                if (!(avatarId == null && oldAvatar == null || StringUtils.equals(avatarId, oldAvatar))) {
                    String oldAvatarId = user.getAvatarId();
                    user.setAvatarId(avatarId);
                    this.api.getEventManager().handle(new UserAvatarUpdateEvent(this.api, this.responseNumber, user, oldAvatarId));
                }
            }
            String gameName = null;
            String gameUrl = null;
            Game.GameType type = null;
            if (!content.isNull("game") && !content.getJSONObject("game").isNull("name")) {
                gameName = content.getJSONObject("game").get("name").toString();
                gameUrl = content.getJSONObject("game").isNull("url") ? null : content.getJSONObject("game").get("url").toString();
                try {
                    type = content.getJSONObject("game").isNull("type") ? Game.GameType.DEFAULT : Game.GameType.fromKey(Integer.parseInt(content.getJSONObject("game").get("type").toString()));
                }
                catch (NumberFormatException ex) {
                    type = Game.GameType.DEFAULT;
                }
            }
            GameImpl nextGame = gameName == null ? null : new GameImpl(gameName, gameUrl, type);
            OnlineStatus status = OnlineStatus.fromKey(content.getString("status"));
            if (content.has("guild_id")) {
                GuildImpl guild = (GuildImpl)this.api.getGuildById(content.getLong("guild_id"));
                MemberImpl member = (MemberImpl)guild.getMember(user);
                if (member == null) {
                    if (status != OnlineStatus.OFFLINE) {
                        guild.getCachedPresenceMap().put(userId, content);
                        return null;
                    }
                } else {
                    if (!member.getOnlineStatus().equals((Object)status)) {
                        OnlineStatus oldStatus = member.getOnlineStatus();
                        member.setOnlineStatus(status);
                        this.api.getEventManager().handle(new UserOnlineStatusUpdateEvent(this.api, this.responseNumber, user, guild, oldStatus));
                    }
                    if (member.getGame() == null ? nextGame != null : !member.getGame().equals(nextGame)) {
                        Game oldGame = member.getGame();
                        member.setGame(nextGame);
                        this.api.getEventManager().handle(new UserGameUpdateEvent(this.api, this.responseNumber, user, guild, oldGame));
                    }
                }
            }
        } else {
            OnlineStatus status = OnlineStatus.fromKey(content.getString("status"));
            if (status == OnlineStatus.OFFLINE) {
                return null;
            }
            if (content.has("guild_id")) {
                GuildImpl guild = (GuildImpl)this.api.getGuildById(content.getLong("guild_id"));
                guild.getCachedPresenceMap().put(userId, content);
            }
        }
        return null;
    }
}

