/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import net.dv8tion.jda.client.entities.Group;
import net.dv8tion.jda.client.events.message.group.react.GroupMessageReactionRemoveAllEvent;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.MessageChannel;
import net.dv8tion.jda.core.entities.PrivateChannel;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.events.message.guild.react.GuildMessageReactionRemoveAllEvent;
import net.dv8tion.jda.core.events.message.priv.react.PrivateMessageReactionRemoveAllEvent;
import net.dv8tion.jda.core.events.message.react.MessageReactionRemoveAllEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.hooks.IEventManager;
import org.json.JSONObject;

public class MessageReactionBulkRemoveHandler
extends SocketHandler {
    public MessageReactionBulkRemoveHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        long messageId = content.getLong("message_id");
        long channelId = content.getLong("channel_id");
        MessageChannel channel = this.api.getTextChannelById(channelId);
        if (channel == null) {
            channel = this.api.getPrivateChannelById(channelId);
        }
        if (channel == null && this.api.getAccountType() == AccountType.CLIENT) {
            channel = this.api.asClient().getGroupById(channelId);
        }
        if (channel == null) {
            channel = this.api.getFakePrivateChannelMap().get(channelId);
        }
        if (channel == null) {
            this.api.getEventCache().cache(EventCache.Type.CHANNEL, channelId, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Received a reaction for a channel that JDA does not currently have cached");
            return null;
        }
        IEventManager manager = this.api.getEventManager();
        switch (channel.getType()) {
            case TEXT: {
                manager.handle(new GuildMessageReactionRemoveAllEvent((JDA)this.api, this.responseNumber, messageId, (TextChannel)channel));
                break;
            }
            case GROUP: {
                manager.handle(new GroupMessageReactionRemoveAllEvent((JDA)this.api, this.responseNumber, messageId, (Group)channel));
                break;
            }
            case PRIVATE: {
                manager.handle(new PrivateMessageReactionRemoveAllEvent((JDA)this.api, this.responseNumber, messageId, (PrivateChannel)channel));
            }
        }
        manager.handle(new MessageReactionRemoveAllEvent(this.api, this.responseNumber, messageId, channel));
        return null;
    }
}

