/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import java.util.Objects;
import net.dv8tion.jda.core.Region;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.events.guild.update.GuildUpdateAfkChannelEvent;
import net.dv8tion.jda.core.events.guild.update.GuildUpdateAfkTimeoutEvent;
import net.dv8tion.jda.core.events.guild.update.GuildUpdateIconEvent;
import net.dv8tion.jda.core.events.guild.update.GuildUpdateMFALevelEvent;
import net.dv8tion.jda.core.events.guild.update.GuildUpdateNameEvent;
import net.dv8tion.jda.core.events.guild.update.GuildUpdateNotificationLevelEvent;
import net.dv8tion.jda.core.events.guild.update.GuildUpdateOwnerEvent;
import net.dv8tion.jda.core.events.guild.update.GuildUpdateRegionEvent;
import net.dv8tion.jda.core.events.guild.update.GuildUpdateSplashEvent;
import net.dv8tion.jda.core.events.guild.update.GuildUpdateVerificationLevelEvent;
import net.dv8tion.jda.core.handle.SocketHandler;
import org.json.JSONObject;

public class GuildUpdateHandler
extends SocketHandler {
    public GuildUpdateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        VoiceChannel afkChannel;
        long id = content.getLong("id");
        if (this.api.getGuildLock().isLocked(id)) {
            return id;
        }
        GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(id);
        Member owner = guild.getMembersMap().get(content.getLong("owner_id"));
        String name = content.getString("name");
        String iconId = !content.isNull("icon") ? content.getString("icon") : null;
        String splashId = !content.isNull("splash") ? content.getString("splash") : null;
        Region region = Region.fromKey(content.getString("region"));
        Guild.VerificationLevel verificationLevel = Guild.VerificationLevel.fromKey(content.getInt("verification_level"));
        Guild.NotificationLevel notificationLevel = Guild.NotificationLevel.fromKey(content.getInt("default_message_notifications"));
        Guild.MFALevel mfaLevel = Guild.MFALevel.fromKey(content.getInt("mfa_level"));
        Guild.Timeout afkTimeout = Guild.Timeout.fromKey(content.getInt("afk_timeout"));
        VoiceChannel voiceChannel = afkChannel = !content.isNull("afk_channel_id") ? guild.getVoiceChannelMap().get(content.getLong("afk_channel_id")) : null;
        if (!Objects.equals(owner, guild.getOwner())) {
            Member oldOwner = guild.getOwner();
            guild.setOwner(owner);
            this.api.getEventManager().handle(new GuildUpdateOwnerEvent(this.api, this.responseNumber, guild, oldOwner));
        }
        if (!Objects.equals(name, guild.getName())) {
            String oldName = guild.getName();
            guild.setName(name);
            this.api.getEventManager().handle(new GuildUpdateNameEvent(this.api, this.responseNumber, guild, oldName));
        }
        if (!Objects.equals(iconId, guild.getIconId())) {
            String oldIconId = guild.getIconId();
            guild.setIconId(iconId);
            this.api.getEventManager().handle(new GuildUpdateIconEvent(this.api, this.responseNumber, guild, oldIconId));
        }
        if (!Objects.equals(splashId, guild.getSplashId())) {
            String oldSplashId = guild.getSplashId();
            guild.setSplashId(splashId);
            this.api.getEventManager().handle(new GuildUpdateSplashEvent(this.api, this.responseNumber, guild, oldSplashId));
        }
        if (!Objects.equals((Object)region, (Object)guild.getRegion())) {
            Region oldRegion = guild.getRegion();
            guild.setRegion(region);
            this.api.getEventManager().handle(new GuildUpdateRegionEvent(this.api, this.responseNumber, guild, oldRegion));
        }
        if (!Objects.equals((Object)verificationLevel, (Object)guild.getVerificationLevel())) {
            Guild.VerificationLevel oldVerificationLevel = guild.getVerificationLevel();
            guild.setVerificationLevel(verificationLevel);
            this.api.getEventManager().handle(new GuildUpdateVerificationLevelEvent(this.api, this.responseNumber, guild, oldVerificationLevel));
        }
        if (!Objects.equals((Object)notificationLevel, (Object)guild.getDefaultNotificationLevel())) {
            Guild.NotificationLevel oldNotificationLevel = guild.getDefaultNotificationLevel();
            guild.setDefaultNotificationLevel(notificationLevel);
            this.api.getEventManager().handle(new GuildUpdateNotificationLevelEvent(this.api, this.responseNumber, guild, oldNotificationLevel));
        }
        if (!Objects.equals((Object)mfaLevel, (Object)guild.getRequiredMFALevel())) {
            Guild.MFALevel oldMfaLevel = guild.getRequiredMFALevel();
            guild.setRequiredMFALevel(mfaLevel);
            this.api.getEventManager().handle(new GuildUpdateMFALevelEvent(this.api, this.responseNumber, guild, oldMfaLevel));
        }
        if (!Objects.equals((Object)afkTimeout, (Object)guild.getAfkTimeout())) {
            Guild.Timeout oldAfkTimeout = guild.getAfkTimeout();
            guild.setAfkTimeout(afkTimeout);
            this.api.getEventManager().handle(new GuildUpdateAfkTimeoutEvent(this.api, this.responseNumber, guild, oldAfkTimeout));
        }
        if (!Objects.equals(afkChannel, guild.getAfkChannel())) {
            VoiceChannel oldAfkChannel = guild.getAfkChannel();
            guild.setAfkChannel(afkChannel);
            this.api.getEventManager().handle(new GuildUpdateAfkChannelEvent(this.api, this.responseNumber, guild, oldAfkChannel));
        }
        return null;
    }
}

