/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import net.dv8tion.jda.client.entities.impl.GroupImpl;
import net.dv8tion.jda.client.entities.impl.JDAClientImpl;
import net.dv8tion.jda.client.events.group.GroupLeaveEvent;
import net.dv8tion.jda.core.audio.hooks.ConnectionStatus;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.PrivateChannel;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.entities.impl.UserImpl;
import net.dv8tion.jda.core.events.channel.priv.PrivateChannelDeleteEvent;
import net.dv8tion.jda.core.events.channel.text.TextChannelDeleteEvent;
import net.dv8tion.jda.core.events.channel.voice.VoiceChannelDeleteEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.managers.impl.AudioManagerImpl;
import org.json.JSONObject;

public class ChannelDeleteHandler
extends SocketHandler {
    public ChannelDeleteHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected Long handleInternally(JSONObject content) {
        ChannelType type = ChannelType.fromId(content.getInt("type"));
        long guildId = 0L;
        if (type.isGuild()) {
            guildId = content.getLong("guild_id");
            if (this.api.getGuildLock().isLocked(guildId)) {
                return guildId;
            }
        }
        long channelId = content.getLong("id");
        switch (type) {
            case TEXT: {
                GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(guildId);
                TextChannel channel = this.api.getTextChannelMap().remove(channelId);
                if (channel == null) {
                    this.api.getEventCache().cache(EventCache.Type.CHANNEL, channelId, () -> this.handle(this.responseNumber, this.allContent));
                    EventCache.LOG.debug("CHANNEL_DELETE attempted to delete a text channel that is not yet cached. JSON: " + content);
                    return null;
                }
                guild.getTextChannelsMap().remove(channel.getIdLong());
                this.api.getEventManager().handle(new TextChannelDeleteEvent(this.api, this.responseNumber, channel));
                break;
            }
            case VOICE: {
                GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(guildId);
                VoiceChannel channel = guild.getVoiceChannelMap().remove(channelId);
                if (channel == null) {
                    this.api.getEventCache().cache(EventCache.Type.CHANNEL, channelId, () -> this.handle(this.responseNumber, this.allContent));
                    EventCache.LOG.debug("CHANNEL_DELETE attempted to delete a voice channel that is not yet cached. JSON: " + content);
                    return null;
                }
                AudioManagerImpl manager = (AudioManagerImpl)this.api.getAudioManagerMap().get(guild.getIdLong());
                if (manager != null && manager.isConnected() && manager.getConnectedChannel().getIdLong() == channel.getIdLong()) {
                    manager.closeAudioConnection(ConnectionStatus.DISCONNECTED_CHANNEL_DELETED);
                }
                guild.getVoiceChannelMap().remove(channel.getIdLong());
                this.api.getEventManager().handle(new VoiceChannelDeleteEvent(this.api, this.responseNumber, channel));
                break;
            }
            case PRIVATE: {
                PrivateChannel channel = this.api.getPrivateChannelMap().remove(channelId);
                if (channel == null) {
                    channel = this.api.getFakePrivateChannelMap().remove(channelId);
                }
                if (channel == null) {
                    this.api.getEventCache().cache(EventCache.Type.CHANNEL, channelId, () -> this.handle(this.responseNumber, this.allContent));
                    EventCache.LOG.debug("CHANNEL_DELETE attempted to delete a private channel that is not yet cached. JSON: " + content);
                    return null;
                }
                if (channel.getUser().isFake()) {
                    this.api.getFakeUserMap().remove(channel.getUser().getIdLong());
                }
                ((UserImpl)channel.getUser()).setPrivateChannel(null);
                this.api.getEventManager().handle(new PrivateChannelDeleteEvent(this.api, this.responseNumber, channel));
                break;
            }
            case GROUP: {
                long groupId = content.getLong("id");
                GroupImpl group = (GroupImpl)((JDAClientImpl)this.api.asClient()).getGroupMap().remove(groupId);
                if (group == null) {
                    this.api.getEventCache().cache(EventCache.Type.CHANNEL, channelId, () -> this.handle(this.responseNumber, this.allContent));
                    EventCache.LOG.debug("CHANNEL_DELETE attempted to delete a group that is not yet cached. JSON: " + content);
                    return null;
                }
                group.getUserMap().forEachEntry((userId, user) -> {
                    if (user.isFake() && !user.hasPrivateChannel() && ((JDAClientImpl)this.api.asClient()).getRelationshipMap().get(userId) == null && this.api.asClient().getGroups().stream().noneMatch(g -> g.getUsers().contains(user))) {
                        this.api.getFakeUserMap().remove(userId);
                    }
                    return true;
                });
                this.api.getEventManager().handle(new GroupLeaveEvent(this.api, this.responseNumber, group));
                break;
            }
            default: {
                throw new IllegalArgumentException("CHANNEL_DELETE provided an unknown channel type. JSON: " + content);
            }
        }
        return null;
    }
}

