/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities.impl;

import java.awt.Color;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.iblitzkriegi.vixio.org.apache.http.util.Args;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.exceptions.PermissionException;
import net.dv8tion.jda.core.managers.RoleManager;
import net.dv8tion.jda.core.managers.RoleManagerUpdatable;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.utils.PermissionUtil;

public class RoleImpl
implements Role {
    private final long id;
    private final Guild guild;
    private final Object mngLock = new Object();
    private volatile RoleManager manager;
    private volatile RoleManagerUpdatable managerUpdatable;
    private String name;
    private Color color;
    private boolean managed;
    private boolean hoisted;
    private boolean mentionable;
    private long rawPermissions;
    private int rawPosition;

    public RoleImpl(long id, Guild guild) {
        this.id = id;
        this.guild = guild;
    }

    @Override
    public int getPosition() {
        if (this == this.guild.getPublicRole()) {
            return -1;
        }
        int i = this.guild.getRoles().size() - 2;
        for (Role r : this.guild.getRoles()) {
            if (r == this) {
                return i;
            }
            --i;
        }
        throw new RuntimeException("Somehow when determining position we never found the role in the Guild's roles? wtf?");
    }

    @Override
    public int getPositionRaw() {
        return this.rawPosition;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isManaged() {
        return this.managed;
    }

    @Override
    public boolean isHoisted() {
        return this.hoisted;
    }

    @Override
    public boolean isMentionable() {
        return this.mentionable;
    }

    @Override
    public long getPermissionsRaw() {
        return this.rawPermissions;
    }

    @Override
    public List<Permission> getPermissions() {
        return Collections.unmodifiableList(Permission.getPermissions(this.rawPermissions));
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public boolean isPublicRole() {
        return this.equals(this.getGuild().getPublicRole());
    }

    @Override
    public boolean hasPermission(Permission ... permissions) {
        long effectivePerms = this.rawPermissions | this.guild.getPublicRole().getPermissionsRaw();
        for (Permission perm : permissions) {
            if ((effectivePerms >> perm.getOffset() & 1L) == 1L) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasPermission(Collection<Permission> permissions) {
        Args.notNull(permissions, "Permission Collection");
        return this.hasPermission(permissions.toArray(new Permission[permissions.size()]));
    }

    @Override
    public boolean hasPermission(Channel channel, Permission ... permissions) {
        long effectivePerms = PermissionUtil.getEffectivePermission(channel, this);
        for (Permission perm : permissions) {
            if ((effectivePerms >> perm.getOffset() & 1L) == 1L) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasPermission(Channel channel, Collection<Permission> permissions) {
        Args.notNull(permissions, "Permission Collection");
        return this.hasPermission(channel, permissions.toArray(new Permission[permissions.size()]));
    }

    @Override
    public boolean canInteract(Role role) {
        return PermissionUtil.canInteract(this, role);
    }

    @Override
    public Guild getGuild() {
        return this.guild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RoleManager getManager() {
        RoleManager mng = this.manager;
        if (mng == null) {
            Object object = this.mngLock;
            synchronized (object) {
                mng = this.manager;
                if (mng == null) {
                    mng = this.manager = new RoleManager(this);
                }
            }
        }
        return mng;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RoleManagerUpdatable getManagerUpdatable() {
        RoleManagerUpdatable mng = this.managerUpdatable;
        if (mng == null) {
            Object object = this.mngLock;
            synchronized (object) {
                mng = this.managerUpdatable;
                if (mng == null) {
                    mng = this.managerUpdatable = new RoleManagerUpdatable(this);
                }
            }
        }
        return mng;
    }

    @Override
    public RestAction<Void> delete() {
        if (!PermissionUtil.checkPermission(this.getGuild(), this.getGuild().getSelfMember(), Permission.MANAGE_ROLES)) {
            throw new PermissionException(Permission.MANAGE_ROLES);
        }
        if (!PermissionUtil.canInteract(this.getGuild().getSelfMember(), (Role)this)) {
            throw new PermissionException("Can't delete role >= highest self-role");
        }
        if (this.managed) {
            throw new UnsupportedOperationException("Cannot delete a Role that is managed. ");
        }
        Route.CompiledRoute route = Route.Roles.DELETE_ROLE.compile(this.guild.getId(), this.getId());
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public JDA getJDA() {
        return this.guild.getJDA();
    }

    @Override
    public String getAsMention() {
        return "<@&" + this.getId() + '>';
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Role)) {
            return false;
        }
        Role oRole = (Role)o;
        return this == oRole || this.getIdLong() == oRole.getIdLong();
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public String toString() {
        return "R:" + this.getName() + '(' + this.id + ')';
    }

    @Override
    public int compareTo(Role r) {
        if (this == r) {
            return 0;
        }
        if (!this.getGuild().equals(r.getGuild())) {
            throw new IllegalArgumentException("Cannot compare roles that aren't from the same guild!");
        }
        if (this.getPositionRaw() != r.getPositionRaw()) {
            return this.getPositionRaw() - r.getPositionRaw();
        }
        OffsetDateTime thisTime = this.getCreationTime();
        OffsetDateTime rTime = r.getCreationTime();
        return rTime.compareTo(thisTime);
    }

    public RoleImpl setName(String name) {
        this.name = name;
        return this;
    }

    public RoleImpl setColor(Color color) {
        this.color = color;
        return this;
    }

    public RoleImpl setManaged(boolean managed) {
        this.managed = managed;
        return this;
    }

    public RoleImpl setHoisted(boolean hoisted) {
        this.hoisted = hoisted;
        return this;
    }

    public RoleImpl setMentionable(boolean mentionable) {
        this.mentionable = mentionable;
        return this;
    }

    public RoleImpl setRawPermissions(long rawPermissions) {
        this.rawPermissions = rawPermissions;
        return this;
    }

    public RoleImpl setRawPosition(int rawPosition) {
        this.rawPosition = rawPosition;
        return this;
    }
}

