/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities.impl;

import java.awt.Color;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import net.dv8tion.jda.core.entities.EmbedType;
import net.dv8tion.jda.core.entities.MessageEmbed;
import org.json.JSONArray;
import org.json.JSONObject;

public class MessageEmbedImpl
implements MessageEmbed {
    private String url;
    private String title;
    private String description;
    private EmbedType type;
    private OffsetDateTime timestamp;
    private Color color;
    private MessageEmbed.Thumbnail thumbnail;
    private MessageEmbed.Provider siteProvider;
    private MessageEmbed.AuthorInfo author;
    private MessageEmbed.VideoInfo videoInfo;
    private MessageEmbed.Footer footer;
    private MessageEmbed.ImageInfo image;
    private List<MessageEmbed.Field> fields;

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public EmbedType getType() {
        return this.type;
    }

    @Override
    public MessageEmbed.Thumbnail getThumbnail() {
        return this.thumbnail;
    }

    @Override
    public MessageEmbed.Provider getSiteProvider() {
        return this.siteProvider;
    }

    @Override
    public MessageEmbed.AuthorInfo getAuthor() {
        return this.author;
    }

    @Override
    public MessageEmbed.VideoInfo getVideoInfo() {
        return this.videoInfo;
    }

    @Override
    public MessageEmbed.Footer getFooter() {
        return this.footer;
    }

    @Override
    public MessageEmbed.ImageInfo getImage() {
        return this.image;
    }

    @Override
    public List<MessageEmbed.Field> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    @Override
    public int getLength() {
        int len = 0;
        if (this.title != null) {
            len += this.title.length();
        }
        if (this.description != null) {
            len += this.description.length();
        }
        if (this.author != null) {
            len += this.author.getName().length();
        }
        if (this.footer != null) {
            len += this.footer.getText().length();
        }
        if (this.fields != null) {
            for (MessageEmbed.Field f : this.fields) {
                len += f.getName().length() + f.getValue().length();
            }
        }
        return len;
    }

    public MessageEmbedImpl setUrl(String url) {
        this.url = url;
        return this;
    }

    public MessageEmbedImpl setTitle(String title) {
        this.title = title;
        return this;
    }

    public MessageEmbedImpl setDescription(String description) {
        this.description = description;
        return this;
    }

    public MessageEmbedImpl setType(EmbedType type) {
        this.type = type;
        return this;
    }

    public MessageEmbedImpl setThumbnail(MessageEmbed.Thumbnail thumbnail) {
        this.thumbnail = thumbnail;
        return this;
    }

    public MessageEmbedImpl setSiteProvider(MessageEmbed.Provider siteProvider) {
        this.siteProvider = siteProvider;
        return this;
    }

    public MessageEmbedImpl setAuthor(MessageEmbed.AuthorInfo author) {
        this.author = author;
        return this;
    }

    public MessageEmbedImpl setVideoInfo(MessageEmbed.VideoInfo videoInfo) {
        this.videoInfo = videoInfo;
        return this;
    }

    public MessageEmbedImpl setFooter(MessageEmbed.Footer footer) {
        this.footer = footer;
        return this;
    }

    public MessageEmbedImpl setImage(MessageEmbed.ImageInfo image) {
        this.image = image;
        return this;
    }

    public MessageEmbedImpl setFields(List<MessageEmbed.Field> fields) {
        this.fields = fields;
        return this;
    }

    public MessageEmbedImpl setColor(Color color) {
        this.color = color;
        return this;
    }

    public MessageEmbedImpl setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MessageEmbed)) {
            return false;
        }
        MessageEmbed oMsg = (MessageEmbed)o;
        return this == oMsg;
    }

    public int hashCode() {
        return this.getUrl().hashCode();
    }

    public String toString() {
        return "EmbedMessage";
    }

    public JSONObject toJSONObject() {
        JSONObject obj = new JSONObject();
        if (this.url != null) {
            obj.put("url", this.url);
        }
        if (this.title != null) {
            obj.put("title", this.title);
        }
        if (this.description != null) {
            obj.put("description", this.description);
        }
        if (this.timestamp != null) {
            obj.put("timestamp", this.timestamp.format(DateTimeFormatter.ISO_INSTANT));
        }
        if (this.color != null) {
            obj.put("color", this.color.getRGB() & 0xFFFFFF);
        }
        if (this.thumbnail != null) {
            obj.put("thumbnail", new JSONObject().put("url", this.thumbnail.getUrl()));
        }
        if (this.siteProvider != null) {
            JSONObject siteProviderObj = new JSONObject();
            if (this.siteProvider.getName() != null) {
                siteProviderObj.put("name", this.siteProvider.getName());
            }
            if (this.siteProvider.getUrl() != null) {
                siteProviderObj.put("url", this.siteProvider.getUrl());
            }
            obj.put("provider", siteProviderObj);
        }
        if (this.author != null) {
            JSONObject authorObj = new JSONObject();
            if (this.author.getName() != null) {
                authorObj.put("name", this.author.getName());
            }
            if (this.author.getUrl() != null) {
                authorObj.put("url", this.author.getUrl());
            }
            if (this.author.getIconUrl() != null) {
                authorObj.put("icon_url", this.author.getIconUrl());
            }
            obj.put("author", authorObj);
        }
        if (this.videoInfo != null) {
            obj.put("video", new JSONObject().put("url", this.videoInfo.getUrl()));
        }
        if (this.footer != null) {
            JSONObject footerObj = new JSONObject();
            if (this.footer.getText() != null) {
                footerObj.put("text", this.footer.getText());
            }
            if (this.footer.getIconUrl() != null) {
                footerObj.put("icon_url", this.footer.getIconUrl());
            }
            obj.put("footer", footerObj);
        }
        if (this.image != null) {
            obj.put("image", new JSONObject().put("url", this.image.getUrl()));
        }
        if (!this.fields.isEmpty()) {
            JSONArray fieldsArray = new JSONArray();
            this.fields.stream().forEach(field -> fieldsArray.put(new JSONObject().put("name", field.getName()).put("value", field.getValue()).put("inline", field.isInline())));
            obj.put("fields", fieldsArray);
        }
        return obj;
    }
}

