/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities.impl;

import gnu.trove.map.TLongObjectMap;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import me.iblitzkriegi.vixio.org.apache.commons.lang3.StringUtils;
import me.iblitzkriegi.vixio.org.apache.http.util.Args;
import net.dv8tion.jda.client.requests.restaction.pagination.MentionPaginationAction;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.Region;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.GuildVoiceState;
import net.dv8tion.jda.core.entities.Invite;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.entities.Webhook;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.exceptions.AccountTypeException;
import net.dv8tion.jda.core.exceptions.PermissionException;
import net.dv8tion.jda.core.managers.AudioManager;
import net.dv8tion.jda.core.managers.GuildController;
import net.dv8tion.jda.core.managers.GuildManager;
import net.dv8tion.jda.core.managers.GuildManagerUpdatable;
import net.dv8tion.jda.core.managers.impl.AudioManagerImpl;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.utils.MiscUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GuildImpl
implements Guild {
    private final long id;
    private final JDAImpl api;
    private final TLongObjectMap<TextChannel> textChannels = MiscUtil.newLongMap();
    private final TLongObjectMap<VoiceChannel> voiceChannels = MiscUtil.newLongMap();
    private final TLongObjectMap<Member> members = MiscUtil.newLongMap();
    private final TLongObjectMap<Role> roles = MiscUtil.newLongMap();
    private final TLongObjectMap<Emote> emotes = MiscUtil.newLongMap();
    private final TLongObjectMap<JSONObject> cachedPresences = MiscUtil.newLongMap();
    private final Object mngLock = new Object();
    private volatile GuildManager manager;
    private volatile GuildManagerUpdatable managerUpdatable;
    private volatile GuildController controller;
    private Member owner;
    private String name;
    private String iconId;
    private String splashId;
    private Region region;
    private TextChannel publicChannel;
    private VoiceChannel afkChannel;
    private Role publicRole;
    private Guild.VerificationLevel verificationLevel;
    private Guild.NotificationLevel defaultNotificationLevel;
    private Guild.MFALevel mfaLevel;
    private Guild.Timeout afkTimeout;
    private boolean available;
    private boolean canSendVerification = false;

    public GuildImpl(JDAImpl api, long id) {
        this.id = id;
        this.api = api;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getIconId() {
        return this.iconId;
    }

    @Override
    public String getIconUrl() {
        return this.iconId == null ? null : "https://cdn.discordapp.com/icons/" + this.id + "/" + this.iconId + ".jpg";
    }

    @Override
    public String getSplashId() {
        return this.splashId;
    }

    @Override
    public String getSplashUrl() {
        return this.splashId == null ? null : "https://cdn.discordapp.com/splashes/" + this.id + "/" + this.splashId + ".jpg";
    }

    @Override
    public VoiceChannel getAfkChannel() {
        return this.afkChannel;
    }

    @Override
    public RestAction<List<Webhook>> getWebhooks() {
        if (!this.getSelfMember().hasPermission(Permission.MANAGE_WEBHOOKS)) {
            throw new PermissionException(Permission.MANAGE_WEBHOOKS);
        }
        Route.CompiledRoute route = Route.Guilds.GET_WEBHOOKS.compile(this.getId());
        return new RestAction<List<Webhook>>((JDA)this.api, route, null){

            @Override
            protected void handleResponse(Response response, Request<List<Webhook>> request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                LinkedList<Webhook> webhooks = new LinkedList<Webhook>();
                JSONArray array = response.getArray();
                EntityBuilder builder = this.api.getEntityBuilder();
                for (Object object : array) {
                    try {
                        webhooks.add(builder.createWebhook((JSONObject)object));
                    }
                    catch (NullPointerException | JSONException e) {
                        JDAImpl.LOG.log(e);
                    }
                }
                request.onSuccess(webhooks);
            }
        };
    }

    @Override
    public Member getOwner() {
        return this.owner;
    }

    @Override
    public Guild.Timeout getAfkTimeout() {
        return this.afkTimeout;
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    @Override
    public boolean isMember(User user) {
        return this.members.containsKey(user.getIdLong());
    }

    @Override
    public Member getSelfMember() {
        return this.getMember(this.getJDA().getSelfUser());
    }

    @Override
    public Member getMember(User user) {
        return this.getMemberById(user.getIdLong());
    }

    @Override
    public Member getMemberById(String userId) {
        return this.members.get(MiscUtil.parseSnowflake(userId));
    }

    @Override
    public Member getMemberById(long userId) {
        return this.members.get(userId);
    }

    @Override
    public List<Member> getMembers() {
        return Collections.unmodifiableList(new ArrayList<Member>(this.members.valueCollection()));
    }

    @Override
    public List<Member> getMembersByName(String name, boolean ignoreCase) {
        Args.notNull(name, "name");
        return Collections.unmodifiableList(this.members.valueCollection().stream().filter(m -> ignoreCase ? name.equalsIgnoreCase(m.getUser().getName()) : name.equals(m.getUser().getName())).collect(Collectors.toList()));
    }

    @Override
    public List<Member> getMembersByNickname(String nickname, boolean ignoreCase) {
        Args.notNull(nickname, "nickname");
        return Collections.unmodifiableList(this.members.valueCollection().stream().filter(m -> ignoreCase ? nickname.equalsIgnoreCase(m.getNickname()) : nickname.equals(m.getNickname())).collect(Collectors.toList()));
    }

    @Override
    public List<Member> getMembersByEffectiveName(String name, boolean ignoreCase) {
        Args.notNull(name, "name");
        return Collections.unmodifiableList(this.members.valueCollection().stream().filter(m -> ignoreCase ? name.equalsIgnoreCase(m.getEffectiveName()) : name.equals(m.getEffectiveName())).collect(Collectors.toList()));
    }

    @Override
    public List<Member> getMembersWithRoles(Role ... roles) {
        Args.notNull(roles, "roles");
        return this.getMembersWithRoles(Arrays.asList(roles));
    }

    @Override
    public List<Member> getMembersWithRoles(Collection<Role> roles) {
        Args.notNull(roles, "roles");
        for (Role r : roles) {
            Args.notNull(r, "Role provided in collection");
            if (r.getGuild().equals(this)) continue;
            throw new IllegalArgumentException("Role provided was from a different Guild! Role: " + r);
        }
        return Collections.unmodifiableList(this.members.valueCollection().stream().filter(m -> m.getRoles().containsAll(roles)).collect(Collectors.toList()));
    }

    @Override
    public TextChannel getTextChannelById(String id) {
        return this.textChannels.get(MiscUtil.parseSnowflake(id));
    }

    @Override
    public TextChannel getTextChannelById(long id) {
        return this.textChannels.get(id);
    }

    @Override
    public List<TextChannel> getTextChannelsByName(String name, boolean ignoreCase) {
        Args.notNull(name, "name");
        return Collections.unmodifiableList(this.textChannels.valueCollection().stream().filter(tc -> ignoreCase ? name.equalsIgnoreCase(tc.getName()) : name.equals(tc.getName())).collect(Collectors.toList()));
    }

    @Override
    public List<TextChannel> getTextChannels() {
        ArrayList<TextChannel> channels = new ArrayList<TextChannel>(this.textChannels.valueCollection());
        channels.sort(Comparator.reverseOrder());
        return Collections.unmodifiableList(channels);
    }

    @Override
    public VoiceChannel getVoiceChannelById(String id) {
        return this.voiceChannels.get(MiscUtil.parseSnowflake(id));
    }

    @Override
    public VoiceChannel getVoiceChannelById(long id) {
        return this.voiceChannels.get(id);
    }

    @Override
    public List<VoiceChannel> getVoiceChannelsByName(String name, boolean ignoreCase) {
        Args.notNull(name, "name");
        return Collections.unmodifiableList(this.voiceChannels.valueCollection().stream().filter(vc -> ignoreCase ? name.equalsIgnoreCase(vc.getName()) : name.equals(vc.getName())).collect(Collectors.toList()));
    }

    @Override
    public List<VoiceChannel> getVoiceChannels() {
        ArrayList<VoiceChannel> channels = new ArrayList<VoiceChannel>(this.voiceChannels.valueCollection());
        channels.sort(Comparator.reverseOrder());
        return Collections.unmodifiableList(channels);
    }

    @Override
    public Role getRoleById(String id) {
        return this.roles.get(MiscUtil.parseSnowflake(id));
    }

    @Override
    public Role getRoleById(long id) {
        return this.roles.get(id);
    }

    @Override
    public List<Role> getRoles() {
        ArrayList<Role> list = new ArrayList<Role>(this.roles.valueCollection());
        list.sort(Comparator.reverseOrder());
        return Collections.unmodifiableList(list);
    }

    @Override
    public List<Role> getRolesByName(String name, boolean ignoreCase) {
        Args.notNull(name, "name");
        return Collections.unmodifiableList(this.roles.valueCollection().stream().filter(r -> ignoreCase ? name.equalsIgnoreCase(r.getName()) : name.equals(r.getName())).collect(Collectors.toList()));
    }

    @Override
    public Emote getEmoteById(String id) {
        return this.emotes.get(MiscUtil.parseSnowflake(id));
    }

    @Override
    public Emote getEmoteById(long id) {
        return this.emotes.get(id);
    }

    @Override
    public List<Emote> getEmotes() {
        return Collections.unmodifiableList(new LinkedList<Emote>(this.emotes.valueCollection()));
    }

    @Override
    public List<Emote> getEmotesByName(String name, boolean ignoreCase) {
        Args.notNull(name, "name");
        return Collections.unmodifiableList(this.emotes.valueCollection().parallelStream().filter(e -> ignoreCase ? StringUtils.equalsIgnoreCase(e.getName(), name) : StringUtils.equals(e.getName(), name)).collect(Collectors.toList()));
    }

    @Override
    public Role getPublicRole() {
        return this.publicRole;
    }

    @Override
    public TextChannel getPublicChannel() {
        return this.publicChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GuildManager getManager() {
        GuildManager mng = this.manager;
        if (mng == null) {
            Object object = this.mngLock;
            synchronized (object) {
                mng = this.manager;
                if (mng == null) {
                    mng = this.manager = new GuildManager(this);
                }
            }
        }
        return mng;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GuildManagerUpdatable getManagerUpdatable() {
        GuildManagerUpdatable mng = this.managerUpdatable;
        if (mng == null) {
            Object object = this.mngLock;
            synchronized (object) {
                mng = this.managerUpdatable;
                if (mng == null) {
                    mng = this.managerUpdatable = new GuildManagerUpdatable(this);
                }
            }
        }
        return mng;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GuildController getController() {
        GuildController ctrl = this.controller;
        if (ctrl == null) {
            Object object = this.mngLock;
            synchronized (object) {
                ctrl = this.controller;
                if (ctrl == null) {
                    ctrl = this.controller = new GuildController(this);
                }
            }
        }
        return ctrl;
    }

    @Override
    public MentionPaginationAction getRecentMentions() {
        if (this.getJDA().getAccountType() != AccountType.CLIENT) {
            throw new AccountTypeException(AccountType.CLIENT);
        }
        return this.getJDA().asClient().getRecentMentions(this);
    }

    @Override
    public RestAction<Void> leave() {
        if (this.owner.equals(this.getSelfMember())) {
            throw new IllegalStateException("Cannot leave a guild that you are the owner of! Transfer guild ownership first!");
        }
        Route.CompiledRoute route = Route.Self.LEAVE_GUILD.compile(this.getId());
        return new RestAction<Void>((JDA)this.api, route, null){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<Void> delete() {
        if (this.api.getSelfUser().isMfaEnabled()) {
            throw new IllegalStateException("Cannot delete a guild without providing MFA code. Use Guild#delete(String)");
        }
        return this.delete(null);
    }

    @Override
    public RestAction<Void> delete(String mfaCode) {
        if (!this.owner.equals(this.getSelfMember())) {
            throw new PermissionException("Cannot delete a guild that you do not own!");
        }
        JSONObject mfaBody = null;
        if (this.api.getSelfUser().isMfaEnabled()) {
            Args.notEmpty(mfaCode, "Provided MultiFactor Auth code");
            mfaBody = new JSONObject().put("code", mfaCode);
        }
        Route.CompiledRoute route = Route.Guilds.DELETE_GUILD.compile(this.getId());
        return new RestAction<Void>((JDA)this.api, route, (Object)mfaBody){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioManager getAudioManager() {
        if (!this.api.isAudioEnabled()) {
            throw new IllegalStateException("Audio is disabled. Cannot retrieve an AudioManager while audio is disabled.");
        }
        TLongObjectMap<AudioManager> audioManagers = this.api.getAudioManagerMap();
        AudioManager mng = audioManagers.get(this.id);
        if (mng == null) {
            TLongObjectMap<AudioManager> tLongObjectMap = audioManagers;
            synchronized (tLongObjectMap) {
                mng = audioManagers.get(this.id);
                if (mng == null) {
                    mng = new AudioManagerImpl(this);
                    audioManagers.put(this.id, mng);
                }
            }
        }
        return mng;
    }

    @Override
    public JDAImpl getJDA() {
        return this.api;
    }

    @Override
    public List<GuildVoiceState> getVoiceStates() {
        return Collections.unmodifiableList(this.members.valueCollection().stream().map(Member::getVoiceState).collect(Collectors.toList()));
    }

    @Override
    public Guild.VerificationLevel getVerificationLevel() {
        return this.verificationLevel;
    }

    @Override
    public Guild.NotificationLevel getDefaultNotificationLevel() {
        return this.defaultNotificationLevel;
    }

    @Override
    public Guild.MFALevel getRequiredMFALevel() {
        return this.mfaLevel;
    }

    @Override
    public boolean checkVerification() {
        if (this.api.getAccountType() == AccountType.BOT) {
            return true;
        }
        if (this.canSendVerification) {
            return true;
        }
        switch (this.verificationLevel) {
            case HIGH: {
                if (ChronoUnit.MINUTES.between(this.getSelfMember().getJoinDate(), OffsetDateTime.now()) < 10L) break;
            }
            case MEDIUM: {
                if (ChronoUnit.MINUTES.between(MiscUtil.getCreationTime(this.api.getSelfUser()), OffsetDateTime.now()) < 5L) break;
            }
            case LOW: {
                if (!this.api.getSelfUser().isVerified()) break;
            }
            case NONE: {
                this.canSendVerification = true;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    @Override
    public long getIdLong() {
        return this.id;
    }

    public GuildImpl setAvailable(boolean available) {
        this.available = available;
        return this;
    }

    public GuildImpl setOwner(Member owner) {
        this.owner = owner;
        return this;
    }

    public GuildImpl setName(String name) {
        this.name = name;
        return this;
    }

    public GuildImpl setIconId(String iconId) {
        this.iconId = iconId;
        return this;
    }

    public GuildImpl setSplashId(String splashId) {
        this.splashId = splashId;
        return this;
    }

    public GuildImpl setRegion(Region region) {
        this.region = region;
        return this;
    }

    public GuildImpl setPublicChannel(TextChannel publicChannel) {
        this.publicChannel = publicChannel;
        return this;
    }

    public GuildImpl setAfkChannel(VoiceChannel afkChannel) {
        this.afkChannel = afkChannel;
        return this;
    }

    public GuildImpl setPublicRole(Role publicRole) {
        this.publicRole = publicRole;
        return this;
    }

    public GuildImpl setVerificationLevel(Guild.VerificationLevel level) {
        this.verificationLevel = level;
        this.canSendVerification = false;
        return this;
    }

    public GuildImpl setDefaultNotificationLevel(Guild.NotificationLevel level) {
        this.defaultNotificationLevel = level;
        return this;
    }

    public GuildImpl setRequiredMFALevel(Guild.MFALevel level) {
        this.mfaLevel = level;
        return this;
    }

    public GuildImpl setAfkTimeout(Guild.Timeout afkTimeout) {
        this.afkTimeout = afkTimeout;
        return this;
    }

    public TLongObjectMap<TextChannel> getTextChannelsMap() {
        return this.textChannels;
    }

    public TLongObjectMap<VoiceChannel> getVoiceChannelMap() {
        return this.voiceChannels;
    }

    public TLongObjectMap<Member> getMembersMap() {
        return this.members;
    }

    public TLongObjectMap<Role> getRolesMap() {
        return this.roles;
    }

    public TLongObjectMap<JSONObject> getCachedPresenceMap() {
        return this.cachedPresences;
    }

    public TLongObjectMap<Emote> getEmoteMap() {
        return this.emotes;
    }

    public boolean equals(Object o) {
        if (!(o instanceof GuildImpl)) {
            return false;
        }
        GuildImpl oGuild = (GuildImpl)o;
        return this == oGuild || this.id == oGuild.id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public String toString() {
        return "G:" + this.getName() + '(' + this.id + ')';
    }

    @Override
    public RestAction<List<Invite>> getInvites() {
        if (!this.getSelfMember().hasPermission(Permission.MANAGE_SERVER)) {
            throw new PermissionException(Permission.MANAGE_SERVER);
        }
        Route.CompiledRoute route = Route.Invites.GET_GUILD_INVITES.compile(this.getId());
        return new RestAction<List<Invite>>((JDA)this.api, route, null){

            @Override
            protected void handleResponse(Response response, Request<List<Invite>> request) {
                if (response.isOk()) {
                    EntityBuilder entityBuilder = this.api.getEntityBuilder();
                    JSONArray array = response.getArray();
                    ArrayList<Invite> invites = new ArrayList<Invite>(array.length());
                    for (int i = 0; i < array.length(); ++i) {
                        invites.add(entityBuilder.createInvite(array.getJSONObject(i)));
                    }
                    request.onSuccess(invites);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }
}

