/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities;

import me.iblitzkriegi.vixio.org.apache.http.util.Args;
import net.dv8tion.jda.core.entities.impl.GameImpl;

public interface Game {
    public String getName();

    public String getUrl();

    public GameType getType();

    public static Game of(String name) {
        return Game.of(name, null);
    }

    public static Game of(String name, String url) {
        Args.notEmpty(name, "Provided game name");
        GameType type = Game.isValidStreamingUrl(url) ? GameType.TWITCH : GameType.DEFAULT;
        return new GameImpl(name, url, type);
    }

    public static boolean isValidStreamingUrl(String url) {
        return url != null && url.matches("^https?:\\/\\/(www\\.)?twitch\\.tv\\/.+");
    }

    public static enum GameType {
        DEFAULT(0),
        TWITCH(1);

        private final int key;

        private GameType(int key) {
            this.key = key;
        }

        public int getKey() {
            return this.key;
        }

        public static GameType fromKey(int key) {
            for (GameType level : GameType.values()) {
                if (level.getKey() != key) continue;
                return level;
            }
            return DEFAULT;
        }
    }
}

