/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.audio.factory;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import net.dv8tion.jda.core.audio.AudioConnection;
import net.dv8tion.jda.core.audio.factory.IAudioSendSystem;
import net.dv8tion.jda.core.audio.factory.IPacketProvider;
import net.dv8tion.jda.core.entities.Guild;

public class DefaultSendSystem
implements IAudioSendSystem {
    private final IPacketProvider packetProvider;
    private Thread sendThread;

    public DefaultSendSystem(IPacketProvider packetProvider) {
        this.packetProvider = packetProvider;
    }

    @Override
    public void start() {
        Guild guild = this.packetProvider.getConnectedChannel().getGuild();
        final DatagramSocket udpSocket = this.packetProvider.getUdpSocket();
        this.sendThread = new Thread(this.packetProvider.getIdentifier() + " Sending Thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                long lastFrameSent = System.currentTimeMillis();
                while (!udpSocket.isClosed() && !DefaultSendSystem.this.sendThread.isInterrupted()) {
                    try {
                        boolean changeTalking;
                        boolean bl = changeTalking = System.currentTimeMillis() - lastFrameSent > 20L;
                        DatagramPacket packet = DefaultSendSystem.this.packetProvider.getNextPacket(changeTalking);
                        if (packet == null) continue;
                        udpSocket.send(packet);
                    }
                    catch (NoRouteToHostException e) {
                        DefaultSendSystem.this.packetProvider.onConnectionLost();
                    }
                    catch (SocketException e) {
                    }
                    catch (Exception e) {
                        AudioConnection.LOG.log(e);
                    }
                    finally {
                        long sleepTime = 20L - (System.currentTimeMillis() - lastFrameSent);
                        if (sleepTime > 0L) {
                            try {
                                Thread.sleep(sleepTime);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        if (System.currentTimeMillis() < lastFrameSent + 60L) {
                            lastFrameSent += 20L;
                            continue;
                        }
                        lastFrameSent = System.currentTimeMillis();
                    }
                }
            }
        };
        this.sendThread.setPriority(7);
        this.sendThread.setDaemon(true);
        this.sendThread.start();
    }

    @Override
    public void shutdown() {
        if (this.sendThread != null) {
            this.sendThread.interrupt();
        }
    }
}

