/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.client.requests.restaction.pagination;

import java.util.LinkedList;
import java.util.List;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.restaction.pagination.PaginationAction;
import org.json.JSONArray;

public class MentionPaginationAction
extends PaginationAction<Message, MentionPaginationAction> {
    protected final Guild guild;
    protected boolean isEveryone = true;
    protected boolean isRole = true;

    public MentionPaginationAction(JDA api) {
        super(api, 1, 100, 25);
        this.guild = null;
    }

    public MentionPaginationAction(Guild guild) {
        super(guild.getJDA(), 1, 100, 25);
        this.guild = guild;
    }

    public Guild getGuild() {
        return this.guild;
    }

    public MentionPaginationAction setEveryone(boolean isEveryoneMention) {
        this.isEveryone = isEveryoneMention;
        return this;
    }

    public MentionPaginationAction setRole(boolean isRoleMention) {
        this.isRole = isRoleMention;
        return this;
    }

    @Override
    protected void finalizeRoute() {
        String limit = String.valueOf(super.getLimit());
        String before = this.cached.isEmpty() ? null : ((Message)this.getLast()).getId();
        String everyone = String.valueOf(this.isEveryone);
        String role = String.valueOf(this.isRole);
        this.route = this.guild != null ? this.prepareGuild(limit, before, everyone, role) : this.prepareGlobal(limit, before, everyone, role);
    }

    @Override
    protected void handleResponse(Response response, Request<List<Message>> request) {
        if (!response.isOk()) {
            request.onFailure(response);
            return;
        }
        EntityBuilder builder = this.api.getEntityBuilder();
        LinkedList<Message> mentions = new LinkedList<Message>();
        JSONArray arr = response.getArray();
        for (int i = 0; i < arr.length(); ++i) {
            Message msg = builder.createMessage(arr.getJSONObject(i), false);
            this.cached.add(msg);
            mentions.add(msg);
        }
        request.onSuccess(mentions);
    }

    protected Route.CompiledRoute prepareGuild(String limit, String before, String everyone, String role) {
        if (before != null) {
            return Route.Self.GET_RECENT_MENTIONS_GUILD_BEFORE.compile(limit, role, everyone, this.guild.getId(), before);
        }
        return Route.Self.GET_RECENT_MENTIONS_GUILD.compile(limit, role, everyone, this.guild.getId());
    }

    protected Route.CompiledRoute prepareGlobal(String limit, String before, String everyone, String role) {
        if (before != null) {
            return Route.Self.GET_RECENT_MENTIONS_BEFORE.compile(limit, role, everyone, before);
        }
        return Route.Self.GET_RECENT_MENTIONS.compile(limit, role, everyone);
    }
}

