/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.util;

import ch.njol.skript.Skript;
import com.sedmelluq.discord.lavaplayer.player.AudioLoadResultHandler;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import me.iblitzkriegi.vixio.Vixio;
import me.iblitzkriegi.vixio.effects.EffLogin;
import me.iblitzkriegi.vixio.util.GuildMusicManager;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.User;

public class VixioAudioHandlers {
    public static synchronized GuildMusicManager getGuildAudioPlayer(Guild guild) {
        String guildId = guild.getId();
        GuildMusicManager musicManager = Vixio.musicManagers.get(guildId);
        if (musicManager == null) {
            musicManager = new GuildMusicManager(Vixio.playerManager);
            Vixio.musicManagers.put(guildId, musicManager);
        }
        guild.getAudioManager().setSendingHandler(musicManager.getSendHandler());
        return musicManager;
    }

    public static void loadAndPlay(Guild guild, String trackUrl, User bot) {
        final GuildMusicManager musicManager = VixioAudioHandlers.getGuildAudioPlayer(guild);
        if (Vixio.reverseGuilds.get(musicManager.player) == null) {
            Vixio.reverseGuilds.put(musicManager.player, guild);
        }
        if (EffLogin.audioPlayers.get(musicManager.player) == null) {
            EffLogin.audioPlayers.put(musicManager.player, bot);
        }
        Vixio.playerManager.loadItemOrdered(musicManager, trackUrl, new AudioLoadResultHandler(){

            @Override
            public void trackLoaded(AudioTrack track) {
                VixioAudioHandlers.play(musicManager, track);
            }

            @Override
            public void playlistLoaded(AudioPlaylist playlist) {
                for (AudioTrack track : playlist.getTracks()) {
                    musicManager.scheduler.queue(track);
                }
            }

            @Override
            public void noMatches() {
                Skript.warning((String)"Noting found by that Audio link.");
            }

            @Override
            public void loadFailed(FriendlyException exception) {
                Skript.warning((String)"Could not load Audio from the provided link.");
            }
        });
    }

    public static void play(GuildMusicManager musicManager, AudioTrack track) {
        musicManager.scheduler.queue(track);
    }

    public static void skipTrack(TextChannel channel) {
        GuildMusicManager musicManager = VixioAudioHandlers.getGuildAudioPlayer(channel.getGuild());
        musicManager.scheduler.nextTrack();
    }
}

