/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.org.apache.http.impl.nio.client;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import me.iblitzkriegi.vixio.org.apache.http.ConnectionReuseStrategy;
import me.iblitzkriegi.vixio.org.apache.http.HttpHost;
import me.iblitzkriegi.vixio.org.apache.http.client.protocol.HttpClientContext;
import me.iblitzkriegi.vixio.org.apache.http.concurrent.BasicFuture;
import me.iblitzkriegi.vixio.org.apache.http.concurrent.FutureCallback;
import me.iblitzkriegi.vixio.org.apache.http.conn.ConnectionKeepAliveStrategy;
import me.iblitzkriegi.vixio.org.apache.http.impl.DefaultConnectionReuseStrategy;
import me.iblitzkriegi.vixio.org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import me.iblitzkriegi.vixio.org.apache.http.impl.nio.client.CloseableHttpAsyncClientBase;
import me.iblitzkriegi.vixio.org.apache.http.impl.nio.client.MinimalClientExchangeHandlerImpl;
import me.iblitzkriegi.vixio.org.apache.http.impl.nio.client.PipeliningClientExchangeHandlerImpl;
import me.iblitzkriegi.vixio.org.apache.http.nio.NHttpClientEventHandler;
import me.iblitzkriegi.vixio.org.apache.http.nio.conn.NHttpClientConnectionManager;
import me.iblitzkriegi.vixio.org.apache.http.nio.protocol.HttpAsyncRequestExecutor;
import me.iblitzkriegi.vixio.org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import me.iblitzkriegi.vixio.org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import me.iblitzkriegi.vixio.org.apache.http.protocol.BasicHttpContext;
import me.iblitzkriegi.vixio.org.apache.http.protocol.HttpContext;
import me.iblitzkriegi.vixio.org.apache.http.protocol.HttpProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class MinimalHttpAsyncClient
extends CloseableHttpAsyncClientBase {
    private final Log log = LogFactory.getLog(this.getClass());
    private final NHttpClientConnectionManager connmgr;
    private final HttpProcessor httpProcessor;
    private final ConnectionReuseStrategy connReuseStrategy;
    private final ConnectionKeepAliveStrategy keepaliveStrategy;

    public MinimalHttpAsyncClient(NHttpClientConnectionManager connmgr, ThreadFactory threadFactory, NHttpClientEventHandler eventHandler, HttpProcessor httpProcessor, ConnectionReuseStrategy connReuseStrategy, ConnectionKeepAliveStrategy keepaliveStrategy) {
        super(connmgr, threadFactory, eventHandler);
        this.connmgr = connmgr;
        this.httpProcessor = httpProcessor;
        this.connReuseStrategy = connReuseStrategy;
        this.keepaliveStrategy = keepaliveStrategy;
    }

    public MinimalHttpAsyncClient(NHttpClientConnectionManager connmgr, HttpProcessor httpProcessor) {
        this(connmgr, Executors.defaultThreadFactory(), new HttpAsyncRequestExecutor(), httpProcessor, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
    }

    @Override
    public <T> Future<T> execute(HttpAsyncRequestProducer requestProducer, HttpAsyncResponseConsumer<T> responseConsumer, HttpContext context, FutureCallback<T> callback) {
        this.ensureRunning();
        BasicFuture<T> future = new BasicFuture<T>(callback);
        HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
        MinimalClientExchangeHandlerImpl<T> handler = new MinimalClientExchangeHandlerImpl<T>(this.log, requestProducer, responseConsumer, localcontext, future, this.connmgr, this.httpProcessor, this.connReuseStrategy, this.keepaliveStrategy);
        try {
            handler.start();
        }
        catch (Exception ex) {
            handler.failed(ex);
        }
        return future;
    }

    @Override
    public <T> Future<List<T>> execute(HttpHost target, List<? extends HttpAsyncRequestProducer> requestProducers, List<? extends HttpAsyncResponseConsumer<T>> responseConsumers, HttpContext context, FutureCallback<List<T>> callback) {
        this.ensureRunning();
        BasicFuture<List<T>> future = new BasicFuture<List<T>>(callback);
        HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
        PipeliningClientExchangeHandlerImpl<T> handler = new PipeliningClientExchangeHandlerImpl<T>(this.log, target, requestProducers, responseConsumers, localcontext, future, this.connmgr, this.httpProcessor, this.connReuseStrategy, this.keepaliveStrategy);
        try {
            handler.start();
        }
        catch (Exception ex) {
            handler.failed(ex);
        }
        return future;
    }
}

