/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.expressions.audio;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.util.ArrayList;
import java.util.List;
import me.iblitzkriegi.vixio.effects.EffLogin;
import me.iblitzkriegi.vixio.registration.ExprAnnotation;
import me.iblitzkriegi.vixio.util.GuildMusicManager;
import me.iblitzkriegi.vixio.util.TrackScheduler;
import me.iblitzkriegi.vixio.util.VixioAudioHandlers;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.Guild;
import org.bukkit.event.Event;

@ExprAnnotation.Expression(name="QueueOfPlayer", title="Queue Of Player", desc="Get the Queue of one of your players", syntax="queue of [audio] player %string% in guild %string%", returntype=List.class, type=ExpressionType.SIMPLE, example="SUBMIT EXAMPLES TO Blitz#3273")
public class ExprPlayerQueueOf
extends SimpleExpression<AudioTrack> {
    private static Expression<String> vBot;
    private static Expression<String> vGuild;

    protected AudioTrack[] get(Event e) {
        return ExprPlayerQueueOf.getQueue(e).toArray(new AudioTrack[0]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends AudioTrack> getReturnType() {
        return AudioTrack.class;
    }

    public String toString(Event event, boolean b) {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean init(Expression<?>[] expr, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        vBot = expr[0];
        vGuild = expr[1];
        return true;
    }

    private static List<AudioTrack> getQueue(Event e) {
        JDA jda = EffLogin.bots.get(vBot.getSingle(e));
        if (jda.getGuildById((String)vGuild.getSingle(e)) != null) {
            Guild g = jda.getGuildById((String)vGuild.getSingle(e));
            GuildMusicManager musicManager = VixioAudioHandlers.getGuildAudioPlayer(g);
            TrackScheduler scheduler = musicManager.scheduler;
            if (scheduler == null) {
                throw new IllegalStateException("OH NO! SCHEDULER IS NULL!");
            }
            ArrayList tracks = scheduler.getQueue();
            if (tracks == null) {
                throw new IllegalStateException("OH NO! TRACKS LIST IS NULL!");
            }
            for (AudioTrack track : tracks) {
                if (track == null) {
                    throw new IllegalStateException("OH NO! THERE IS A NULL TRACK IN THE QUEUE");
                }
                if (track.getInfo() == null) {
                    throw new IllegalStateException("OH NO! THE TRACK INFO IS NULL");
                }
                if (track.getInfo().title == null) {
                    throw new IllegalStateException("OH NO! THE TITLE IS NULL");
                }
                if (track.getInfo().author != null) continue;
                throw new IllegalStateException("OH NO! THE AUTHOR IS NULL");
            }
            return tracks;
        }
        Skript.warning((String)"Could not find Guild via that ID");
        return null;
    }
}

