/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.youtube;

import com.sedmelluq.discord.lavaplayer.player.DefaultAudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeAudioTrack;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeMixProvider;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeSearchProvider;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeSignatureCipherManager;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.iblitzkriegi.vixio.org.apache.http.client.config.RequestConfig;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.CloseableHttpResponse;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.HttpGet;
import me.iblitzkriegi.vixio.org.apache.http.client.utils.URLEncodedUtils;
import org.apache.commons.io.IOUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YoutubeAudioSourceManager
implements AudioSourceManager,
HttpConfigurable {
    private static final Logger log = LoggerFactory.getLogger(YoutubeAudioSourceManager.class);
    static final String CHARSET = "UTF-8";
    private static final String VIDEO_ID_REGEX = "([a-zA-Z0-9_-]{11})";
    private static final String PLAYLIST_REGEX = "((PL|LL|FL|UU)[a-zA-Z0-9_-]+)";
    private static final String MIX_REGEX = "(RD[a-zA-Z0-9_-]+)";
    private static final String PROTOCOL_REGEX = "(?:http://|https://|)";
    private static final String SUFFIX_REGEX = "(?:\\?.*|&.*|)";
    private static final String SEARCH_PREFIX = "ytsearch:";
    private static final Pattern[] validTrackPatterns = new Pattern[]{Pattern.compile("^([a-zA-Z0-9_-]{11})$"), Pattern.compile("^(?:http://|https://|)(?:www\\.|)youtube.com/watch\\?v=([a-zA-Z0-9_-]{11})(?:\\?.*|&.*|)$"), Pattern.compile("^(?:http://|https://|)(?:www\\.|)youtu.be/([a-zA-Z0-9_-]{11})(?:\\?.*|&.*|)$")};
    private static final Pattern[] validPlaylistPatterns = new Pattern[]{Pattern.compile("^((PL|LL|FL|UU)[a-zA-Z0-9_-]+)$"), Pattern.compile("^(?:http://|https://|)(?:www\\.|)youtube.com/playlist\\?list=((PL|LL|FL|UU)[a-zA-Z0-9_-]+)(?:\\?.*|&.*|)$")};
    private static final String LIST_PARAMETER = "&list=";
    private static final Pattern playlistEmbeddedPattern = Pattern.compile("&list=((PL|LL|FL|UU)[a-zA-Z0-9_-]+)");
    private static final Pattern mixEmbeddedPattern = Pattern.compile("&list=(RD[a-zA-Z0-9_-]+)");
    private final YoutubeSignatureCipherManager signatureCipherManager = new YoutubeSignatureCipherManager();
    private final HttpInterfaceManager httpInterfaceManager = HttpClientTools.createDefaultThreadLocalManager();
    private final YoutubeSearchProvider searchProvider;
    private final YoutubeMixProvider mixProvider;
    private final boolean allowSearch;
    private volatile int playlistPageCount;

    public YoutubeAudioSourceManager() {
        this(true);
    }

    public YoutubeAudioSourceManager(boolean allowSearch) {
        this.allowSearch = allowSearch;
        this.playlistPageCount = 6;
        this.searchProvider = new YoutubeSearchProvider(this);
        this.mixProvider = new YoutubeMixProvider(this);
    }

    public void setPlaylistPageCount(int playlistPageCount) {
        this.playlistPageCount = playlistPageCount;
    }

    @Override
    public String getSourceName() {
        return "youtube";
    }

    @Override
    public AudioItem loadItem(DefaultAudioPlayerManager manager, AudioReference reference) {
        try {
            return this.loadItemOnce(reference);
        }
        catch (FriendlyException exception) {
            if (HttpClientTools.isRetriableNetworkException(exception.getCause())) {
                return this.loadItemOnce(reference);
            }
            throw exception;
        }
    }

    @Override
    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    @Override
    public void encodeTrack(AudioTrack track, DataOutput output) {
    }

    @Override
    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) {
        return new YoutubeAudioTrack(trackInfo, this);
    }

    @Override
    public void shutdown() {
        IOUtils.closeQuietly((Closeable)this.httpInterfaceManager);
        this.mixProvider.shutdown();
    }

    public YoutubeSignatureCipherManager getCipherManager() {
        return this.signatureCipherManager;
    }

    public HttpInterface getHttpInterface() {
        return this.httpInterfaceManager.getInterface();
    }

    @Override
    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        this.httpInterfaceManager.configureRequests(configurator);
    }

    private AudioItem loadItemOnce(AudioReference reference) {
        if (this.allowSearch && reference.identifier.startsWith(SEARCH_PREFIX)) {
            return this.searchProvider.loadSearchResult(reference.identifier.substring(SEARCH_PREFIX.length()).trim());
        }
        AudioItem result = this.loadTrack(reference.identifier);
        if (result == null) {
            result = this.loadPlaylist(reference.identifier);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AudioItem loadTrackWithVideoId(String videoId, boolean mustExist) {
        try (HttpInterface httpInterface = this.getHttpInterface();){
            JsonBrowser info = this.getTrackInfoFromMainPage(httpInterface, videoId, mustExist);
            if (info == null) {
                AudioReference audioReference = AudioReference.NO_TRACK;
                return audioReference;
            }
            JsonBrowser args = info.get("args");
            if ("fail".equals(args.get("status").text())) {
                throw new FriendlyException(args.get("reason").text(), FriendlyException.Severity.COMMON, null);
            }
            boolean isStream = "1".equals(args.get("live_playback").text());
            long duration = isStream ? Long.MAX_VALUE : args.get("length_seconds").as(Long.class) * 1000L;
            YoutubeAudioTrack youtubeAudioTrack = this.buildTrackObject(videoId, args.get("title").text(), args.get("author").text(), isStream, duration);
            return youtubeAudioTrack;
        }
        catch (Exception e) {
            throw ExceptionTools.wrapUnfriendlyExceptions("Loading information for a YouTube track failed.", FriendlyException.Severity.FAULT, e);
        }
    }

    public AudioTrack findSelectedTrack(List<AudioTrack> tracks, String selectedVideoId) {
        if (selectedVideoId != null) {
            for (AudioTrack track : tracks) {
                if (!selectedVideoId.equals(track.getIdentifier())) continue;
                return track;
            }
        }
        return null;
    }

    private AudioItem loadTrack(String identifier) {
        for (Pattern pattern : validTrackPatterns) {
            Matcher matcher = pattern.matcher(identifier);
            if (!matcher.matches()) continue;
            Matcher playlistMatcher = playlistEmbeddedPattern.matcher(identifier);
            Matcher mixMatcher = mixEmbeddedPattern.matcher(identifier);
            if (playlistMatcher.find()) {
                return this.loadLinkedPlaylistWithId(playlistMatcher.group(1), matcher.group(1));
            }
            if (mixMatcher.find()) {
                return this.mixProvider.loadMixWithId(mixMatcher.group(1), matcher.group(1));
            }
            return this.loadTrackWithVideoId(matcher.group(1), false);
        }
        return null;
    }

    private AudioItem loadLinkedPlaylistWithId(String playlistId, String videoId) {
        AudioPlaylist playlist = this.loadPlaylistWithId(playlistId, videoId);
        if (playlist == null) {
            return this.loadTrackWithVideoId(videoId, false);
        }
        return playlist;
    }

    public JsonBrowser getTrackInfoFromMainPage(HttpInterface httpInterface, String videoId, boolean mustExist) throws Exception {
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(YoutubeAudioSourceManager.getWatchUrl(videoId)));){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new IOException("Invalid status code for video page response: " + statusCode);
            }
            String html = IOUtils.toString(response.getEntity().getContent(), Charset.forName(CHARSET));
            String configJson = DataFormatTools.extractBetween(html, "ytplayer.config = ", ";ytplayer.load");
            if (configJson != null) {
                JsonBrowser jsonBrowser = JsonBrowser.parse(configJson);
                return jsonBrowser;
            }
        }
        if (this.determineFailureReason(httpInterface, videoId, mustExist)) {
            return null;
        }
        return this.getTrackInfoFromEmbedPage(httpInterface, videoId);
    }

    private boolean determineFailureReason(HttpInterface httpInterface, String videoId, boolean mustExist) throws Exception {
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet("https://www.youtube.com/get_video_info?hl=en_GB&video_id=" + videoId));){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new IOException("Invalid status code for video info response: " + statusCode);
            }
            Map<String, String> format = DataFormatTools.convertToMapLayout(URLEncodedUtils.parse(response.getEntity()));
            boolean bl = this.determineFailureReasonFromStatus(format.get("status"), format.get("reason"), mustExist);
            return bl;
        }
    }

    private boolean determineFailureReasonFromStatus(String status, String reason, boolean mustExist) {
        if ("fail".equals(status)) {
            if ("This video does not exist.".equals(reason) && !mustExist) {
                return true;
            }
            if (reason != null) {
                throw new FriendlyException(reason, FriendlyException.Severity.COMMON, null);
            }
        } else if ("ok".equals(status)) {
            return false;
        }
        throw new FriendlyException("Track is unavailable for an unknown reason.", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("Main page had no video, but video info has no error."));
    }

    private JsonBrowser getTrackInfoFromEmbedPage(HttpInterface httpInterface, String videoId) throws Exception {
        JsonBrowser basicInfo = this.loadTrackBaseInfoFromEmbedPage(httpInterface, videoId);
        basicInfo.put("args", this.loadTrackArgsFromVideoInfoPage(httpInterface, videoId, basicInfo.get("sts").text()));
        return basicInfo;
    }

    private JsonBrowser loadTrackBaseInfoFromEmbedPage(HttpInterface httpInterface, String videoId) throws Exception {
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet("https://www.youtube.com/embed/" + videoId));){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new IOException("Invalid status code for embed video page response: " + statusCode);
            }
            String html = IOUtils.toString(response.getEntity().getContent(), Charset.forName(CHARSET));
            String configJson = DataFormatTools.extractBetween(html, "'PLAYER_CONFIG': ", ",'EXPERIMENT_FLAGS'");
            if (configJson != null) {
                JsonBrowser jsonBrowser = JsonBrowser.parse(configJson);
                return jsonBrowser;
            }
        }
        throw new FriendlyException("Track information is unavailable.", FriendlyException.Severity.SUSPICIOUS, new IllegalStateException("Expected player config is not present in embed page."));
    }

    private Map<String, String> loadTrackArgsFromVideoInfoPage(HttpInterface httpInterface, String videoId, String sts) throws Exception {
        String url = "https://www.youtube.com/get_video_info?hl=en_GB&video_id=" + videoId + "&sts=" + sts;
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(url));){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new IOException("Invalid status code for video info response: " + statusCode);
            }
            Map<String, String> map = DataFormatTools.convertToMapLayout(URLEncodedUtils.parse(response.getEntity()));
            return map;
        }
    }

    private AudioPlaylist loadPlaylist(String identifier) {
        for (Pattern pattern : validPlaylistPatterns) {
            Matcher matcher = pattern.matcher(identifier);
            if (!matcher.matches()) continue;
            return this.loadPlaylistWithId(matcher.group(1), null);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private AudioPlaylist loadPlaylistWithId(String playlistId, String selectedVideoId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private AudioPlaylist buildPlaylist(HttpInterface httpInterface, Document document, String selectedVideoId) throws IOException {
        boolean isAccessible;
        boolean bl = isAccessible = !document.select("#pl-header").isEmpty();
        if (!isAccessible) {
            if (selectedVideoId != null) {
                return null;
            }
            throw new FriendlyException("The playlist is private.", FriendlyException.Severity.COMMON, null);
        }
        Element container = document.select("#pl-header").first().parent();
        String playlistName = container.select(".pl-header-title").first().text();
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        String loadMoreUrl = this.extractPlaylistTracks(container, container, tracks);
        int loadCount = 0;
        int pageCount = this.playlistPageCount;
        while (loadMoreUrl != null && ++loadCount < pageCount) {
            CloseableHttpResponse response = httpInterface.execute(new HttpGet("https://www.youtube.com" + loadMoreUrl));
            Throwable throwable = null;
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode != 200) {
                    throw new IOException("Invalid status code for playlist response: " + statusCode);
                }
                JsonBrowser json = JsonBrowser.parse(response.getEntity().getContent());
                String html = json.get("content_html").text();
                Document videoContainer = Jsoup.parse("<table>" + html + "</table>", "");
                String moreHtml = json.get("load_more_widget_html").text();
                Document moreContainer = moreHtml != null ? Jsoup.parse(moreHtml) : null;
                loadMoreUrl = this.extractPlaylistTracks(videoContainer, moreContainer, tracks);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (response == null) continue;
                if (throwable != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                response.close();
            }
        }
        return new BasicAudioPlaylist(playlistName, tracks, this.findSelectedTrack(tracks, selectedVideoId), false);
    }

    private String extractPlaylistTracks(Element videoContainer, Element loadMoreContainer, List<AudioTrack> tracks) {
        Elements more;
        for (Element video : videoContainer.select(".pl-video")) {
            Elements lengthElements = video.select(".timestamp span");
            if (lengthElements.isEmpty()) continue;
            String videoId = video.attr("data-video-id").trim();
            String title = video.attr("data-title").trim();
            String author = video.select(".pl-video-owner a").text().trim();
            long duration = DataFormatTools.durationTextToMillis(lengthElements.first().text());
            tracks.add(this.buildTrackObject(videoId, title, author, false, duration));
        }
        if (loadMoreContainer != null && !(more = loadMoreContainer.select(".load-more-button")).isEmpty()) {
            return more.first().attr("data-uix-load-more-href");
        }
        return null;
    }

    public YoutubeAudioTrack buildTrackObject(String videoId, String title, String uploader, boolean isStream, long duration) {
        return new YoutubeAudioTrack(new AudioTrackInfo(title, uploader, duration, videoId, isStream, YoutubeAudioSourceManager.getWatchUrl(videoId)), this);
    }

    private static String getWatchUrl(String videoId) {
        return "https://www.youtube.com/watch?v=" + videoId;
    }
}

