/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.beam;

import com.sedmelluq.discord.lavaplayer.player.DefaultAudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.beam.BeamAudioTrack;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.iblitzkriegi.vixio.org.apache.http.client.config.RequestConfig;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.HttpGet;

public class BeamAudioSourceManager
implements AudioSourceManager,
HttpConfigurable {
    private static final String STREAM_NAME_REGEX = "^https://(?:www\\.)?beam.pro/([^/]+)$";
    private static final Pattern streamNameRegex = Pattern.compile("^https://(?:www\\.)?beam.pro/([^/]+)$");
    private final HttpInterfaceManager httpInterfaceManager = HttpClientTools.createDefaultThreadLocalManager();

    @Override
    public String getSourceName() {
        return "beam.pro";
    }

    @Override
    public AudioItem loadItem(DefaultAudioPlayerManager manager, AudioReference reference) {
        String streamName = BeamAudioSourceManager.getChannelNameFromUrl(reference.identifier);
        if (streamName == null) {
            return null;
        }
        JsonBrowser channelInfo = this.fetchStreamChannelInfo(streamName);
        if (channelInfo == null) {
            return AudioReference.NO_TRACK;
        }
        String displayName = channelInfo.get("name").text();
        String id = channelInfo.get("id").text();
        if (displayName == null || id == null) {
            throw new IllegalStateException("Expected id and name fields from Beam channel info.");
        }
        return new BeamAudioTrack(new AudioTrackInfo(displayName, streamName, Long.MAX_VALUE, id + "|" + streamName + "|" + reference.identifier, true, "https://beam.pro/" + streamName), this);
    }

    @Override
    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    @Override
    public void encodeTrack(AudioTrack track, DataOutput output) throws IOException {
    }

    @Override
    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        return new BeamAudioTrack(trackInfo, this);
    }

    @Override
    public void shutdown() {
    }

    private static String getChannelNameFromUrl(String url) {
        Matcher matcher = streamNameRegex.matcher(url);
        if (!matcher.matches()) {
            return null;
        }
        return matcher.group(1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonBrowser fetchStreamChannelInfo(String name) {
        try (HttpInterface httpInterface = this.getHttpInterface();){
            JsonBrowser jsonBrowser = HttpClientTools.fetchResponseAsJson(httpInterface, new HttpGet("https://beam.pro/api/v1/channels/" + name));
            return jsonBrowser;
        }
        catch (IOException e) {
            throw new FriendlyException("Loading Beam channel information failed.", FriendlyException.Severity.SUSPICIOUS, e);
        }
    }

    public HttpInterface getHttpInterface() {
        return this.httpInterfaceManager.getInterface();
    }

    @Override
    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        this.httpInterfaceManager.configureRequests(configurator);
    }
}

