/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.natives.mp3;

import com.sedmelluq.discord.lavaplayer.natives.NativeResourceHolder;
import com.sedmelluq.discord.lavaplayer.natives.mp3.Mp3DecoderLibrary;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

public class Mp3Decoder
extends NativeResourceHolder {
    public static final long SAMPLES_PER_FRAME = 1152L;
    public static final int HEADER_SIZE = 4;
    private final Mp3DecoderLibrary library = Mp3DecoderLibrary.getInstance();
    private final long instance = this.library.create();

    public Mp3Decoder() {
        if (this.instance == 0L) {
            throw new IllegalStateException("Failed to create a decoder instance");
        }
    }

    public int decode(ByteBuffer directInput, ShortBuffer directOutput) {
        this.checkNotReleased();
        if (!directInput.isDirect() || !directOutput.isDirect()) {
            throw new IllegalArgumentException("Arguments must be direct buffers.");
        }
        int result = this.library.decode(this.instance, directInput, directInput.remaining(), directOutput, directOutput.remaining() * 2);
        if (result == -10 || result == -11) {
            result = 0;
        } else if (result < 0) {
            throw new IllegalStateException("Decoding failed with error " + result);
        }
        directOutput.position(result / 2);
        directOutput.flip();
        return result / 2;
    }

    @Override
    protected void freeResources() {
        this.library.destroy(this.instance);
    }

    private static int getFrameBitRate(byte[] buffer, int offset) {
        return Mp3Decoder.isMpegVersionOne(buffer, offset) ? Mp3Decoder.getFrameBitRateV1(buffer, offset) : Mp3Decoder.getFrameBitRateV2(buffer, offset);
    }

    private static int getFrameBitRateV1(byte[] buffer, int offset) {
        switch ((buffer[offset + 2] & 0xF0) >>> 4) {
            case 1: {
                return 32000;
            }
            case 2: {
                return 40000;
            }
            case 3: {
                return 48000;
            }
            case 4: {
                return 56000;
            }
            case 5: {
                return 64000;
            }
            case 6: {
                return 80000;
            }
            case 7: {
                return 96000;
            }
            case 8: {
                return 112000;
            }
            case 9: {
                return 128000;
            }
            case 10: {
                return 160000;
            }
            case 11: {
                return 192000;
            }
            case 12: {
                return 224000;
            }
            case 13: {
                return 256000;
            }
            case 14: {
                return 320000;
            }
        }
        throw new IllegalArgumentException("Not valid bitrate");
    }

    private static int getFrameBitRateV2(byte[] buffer, int offset) {
        switch ((buffer[offset + 2] & 0xF0) >>> 4) {
            case 1: {
                return 8000;
            }
            case 2: {
                return 16000;
            }
            case 3: {
                return 24000;
            }
            case 4: {
                return 32000;
            }
            case 5: {
                return 40000;
            }
            case 6: {
                return 48000;
            }
            case 7: {
                return 56000;
            }
            case 8: {
                return 64000;
            }
            case 9: {
                return 80000;
            }
            case 10: {
                return 96000;
            }
            case 11: {
                return 112000;
            }
            case 12: {
                return 128000;
            }
            case 13: {
                return 140000;
            }
            case 14: {
                return 160000;
            }
        }
        throw new IllegalArgumentException("Not valid bitrate");
    }

    private static int calculateFrameSize(int bitRate, int sampleRate, boolean hasPadding) {
        return 144 * bitRate / sampleRate + (hasPadding ? 1 : 0);
    }

    public static int getFrameSampleRate(byte[] buffer, int offset) {
        return Mp3Decoder.isMpegVersionOne(buffer, offset) ? Mp3Decoder.getFrameSampleRateV1(buffer, offset) : Mp3Decoder.getFrameSampleRateV2(buffer, offset);
    }

    public static int getFrameChannelCount(byte[] buffer, int offset) {
        return (buffer[offset + 3] & 0xC0) == 192 ? 1 : 2;
    }

    private static int getFrameSampleRateV1(byte[] buffer, int offset) {
        switch ((buffer[offset + 2] & 0xC) >>> 2) {
            case 0: {
                return 44100;
            }
            case 1: {
                return 48000;
            }
            case 2: {
                return 32000;
            }
        }
        throw new IllegalArgumentException("Not valid sample rate");
    }

    private static int getFrameSampleRateV2(byte[] buffer, int offset) {
        switch ((buffer[offset + 2] & 0xC) >>> 2) {
            case 0: {
                return 22050;
            }
            case 1: {
                return 24000;
            }
            case 2: {
                return 16000;
            }
        }
        throw new IllegalArgumentException("Not valid sample rate");
    }

    public static int getFrameSize(byte[] buffer, int offset) {
        boolean invalid;
        int first = buffer[offset] & 0xFF;
        int second = buffer[offset + 1] & 0xFF;
        int third = buffer[offset + 2] & 0xFF;
        boolean bl = invalid = first != 255 || (second & 0xE0) != 224 || (second & 0x10) != 16 || (second & 6) != 2 || (third & 0xF0) == 0 || (third & 0xF0) == 240 || (third & 0xC) == 12 || (buffer[offset + 3] & 0xC0) == 128;
        if (invalid) {
            return 0;
        }
        int bitRate = Mp3Decoder.getFrameBitRate(buffer, offset);
        int sampleRate = Mp3Decoder.getFrameSampleRate(buffer, offset);
        boolean hasPadding = (third & 2) != 0;
        return Mp3Decoder.calculateFrameSize(bitRate, sampleRate, hasPadding);
    }

    public static double getAverageFrameSize(byte[] buffer, int offset) {
        int bitRate = Mp3Decoder.getFrameBitRate(buffer, offset);
        int sampleRate = Mp3Decoder.getFrameSampleRate(buffer, offset);
        return 144.0 * (double)bitRate / (double)sampleRate;
    }

    private static boolean isMpegVersionOne(byte[] buffer, int offset) {
        return (buffer[offset + 1] & 8) == 8;
    }

    public static int getMaximumFrameSize() {
        return Mp3Decoder.calculateFrameSize(320000, 32000, true);
    }
}

