/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.container.matroska;

import com.sedmelluq.discord.lavaplayer.container.matroska.MatroskaTrackConsumer;
import com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaCuePoint;
import com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaElement;
import com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaElementType;
import com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaFileReader;
import com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaFileTrack;
import com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaFixedBlock;
import com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MatroskaStreamingFile {
    private final MatroskaFileReader reader;
    private long timecodeScale = 1000000L;
    private double duration;
    private final ArrayList<MatroskaFileTrack> trackList = new ArrayList();
    private MatroskaElement firstClusterElement = null;
    private long minimumTimecode = 0L;
    private boolean seeking = false;
    private Long segmentElementPosition = null;
    private Long segmentEndPosition = null;
    private Long cueElementPosition = null;
    private List<MatroskaCuePoint> cuePoints = null;

    public MatroskaStreamingFile(SeekableInputStream inputStream) {
        this.reader = new MatroskaFileReader(inputStream);
    }

    public long getTimecodeScale() {
        return this.timecodeScale;
    }

    public double getDuration() {
        return this.duration;
    }

    public MatroskaFileTrack[] getTrackList() {
        if (!this.trackList.isEmpty()) {
            MatroskaFileTrack[] tracks = new MatroskaFileTrack[this.trackList.size()];
            for (int t = 0; t < this.trackList.size(); ++t) {
                tracks[t] = this.trackList.get(t);
            }
            return tracks;
        }
        return new MatroskaFileTrack[0];
    }

    public void readFile() throws IOException {
        MatroskaElement ebmlElement = this.reader.readNextElement(null);
        if (ebmlElement == null) {
            throw new RuntimeException("Unable to scan for EBML elements");
        }
        if (!ebmlElement.is(MatroskaElementType.Ebml)) {
            throw new RuntimeException("EBML Header not the first element in the file");
        }
        this.parseEbmlElement(ebmlElement);
        MatroskaElement segmentElement = this.reader.readNextElement(null);
        this.segmentElementPosition = segmentElement.position + (long)segmentElement.headerSize;
        this.segmentEndPosition = this.segmentElementPosition + (long)segmentElement.dataSize;
        if (!segmentElement.is(MatroskaElementType.Segment)) {
            throw new RuntimeException(String.format("Segment not the second element in the file: was %s (%d) instead", segmentElement.type.name(), segmentElement.id));
        }
        this.parseSegmentElement(segmentElement);
    }

    private void parseEbmlElement(MatroskaElement ebmlElement) throws IOException {
        MatroskaElement child;
        while ((child = this.reader.readNextElement(ebmlElement)) != null) {
            String docType;
            if (child.is(MatroskaElementType.DocType) && (docType = this.reader.asString(child)).compareTo("matroska") != 0 && docType.compareTo("webm") != 0) {
                throw new RuntimeException("Error: DocType is not matroska, \"" + docType + "\"");
            }
            this.reader.skip(child);
        }
    }

    private void parseSegmentElement(MatroskaElement segmentElement) throws IOException {
        MatroskaElement child;
        while ((child = this.reader.readNextElement(segmentElement)) != null) {
            if (child.is(MatroskaElementType.Info)) {
                this.parseSegmentInfo(child);
            } else if (child.is(MatroskaElementType.Tracks)) {
                this.parseTracks(child);
            } else {
                if (child.is(MatroskaElementType.Cluster)) {
                    this.firstClusterElement = child;
                    break;
                }
                if (child.is(MatroskaElementType.SeekHead)) {
                    this.parseSeekInfoForCuePosition(child);
                } else if (child.is(MatroskaElementType.Cues)) {
                    this.cuePoints = this.parseCues(child);
                }
            }
            this.reader.skip(child);
        }
    }

    private void parseSeekInfoForCuePosition(MatroskaElement seekHeadElement) throws IOException {
        MatroskaElement child;
        while ((child = this.reader.readNextElement(seekHeadElement)) != null) {
            if (child.is(MatroskaElementType.Seek)) {
                this.parseSeekElement(child);
            }
            this.reader.skip(child);
        }
    }

    private void parseSeekElement(MatroskaElement seekElement) throws IOException {
        MatroskaElement child;
        boolean isCueElement = false;
        while ((child = this.reader.readNextElement(seekElement)) != null) {
            if (child.is(MatroskaElementType.SeekId)) {
                isCueElement = ByteBuffer.wrap(this.reader.asBytes(child)).equals(ByteBuffer.wrap(MatroskaElementType.Cues.bytes));
            } else if (child.is(MatroskaElementType.SeekPosition) && isCueElement) {
                this.cueElementPosition = this.reader.asLong(child);
            }
            this.reader.skip(child);
        }
    }

    private List<MatroskaCuePoint> parseCues(MatroskaElement cuesElement) throws IOException {
        MatroskaElement child;
        ArrayList<MatroskaCuePoint> parsedCuePoints = new ArrayList<MatroskaCuePoint>();
        while ((child = this.reader.readNextElement(cuesElement)) != null) {
            MatroskaCuePoint cuePoint;
            if (child.is(MatroskaElementType.CuePoint) && (cuePoint = this.parseCuePoint(child)) != null) {
                parsedCuePoints.add(cuePoint);
            }
            this.reader.skip(child);
        }
        return parsedCuePoints.isEmpty() ? null : parsedCuePoints;
    }

    private MatroskaCuePoint parseCuePoint(MatroskaElement cuePointElement) throws IOException {
        MatroskaElement child;
        Long cueTime = null;
        long[] positions = null;
        while ((child = this.reader.readNextElement(cuePointElement)) != null) {
            if (child.is(MatroskaElementType.CueTime)) {
                cueTime = this.reader.asLong(child);
            } else if (child.is(MatroskaElementType.CueTrackPositions)) {
                positions = this.parseCueTrackPositions(child);
            }
            this.reader.skip(child);
        }
        if (cueTime != null && positions != null) {
            return new MatroskaCuePoint(cueTime, positions);
        }
        return null;
    }

    private long[] parseCueTrackPositions(MatroskaElement positionsElement) throws IOException {
        MatroskaElement child;
        Long currentTrackId = null;
        long[] positions = new long[this.trackList.size() + 1];
        Arrays.fill(positions, -1L);
        while ((child = this.reader.readNextElement(positionsElement)) != null) {
            if (child.is(MatroskaElementType.CueTrack)) {
                currentTrackId = this.reader.asLong(child);
            } else if (child.is(MatroskaElementType.CueClusterPosition) && currentTrackId != null) {
                positions[currentTrackId.intValue()] = this.reader.asLong(child);
            }
            this.reader.skip(child);
        }
        return positions;
    }

    public void seekToTimecode(int trackId, long timecode) {
        try {
            this.seekToTimecodeInternal(trackId, timecode);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void seekToTimecodeInternal(int trackId, long timecode) throws IOException {
        MatroskaCuePoint cuePoint;
        this.minimumTimecode = timecode;
        this.seeking = true;
        if (this.cuePoints == null && this.cueElementPosition != null) {
            this.reader.seek(this.segmentElementPosition + this.cueElementPosition);
            MatroskaElement cuesElement = this.reader.readNextElement(null);
            if (!cuesElement.is(MatroskaElementType.Cues)) {
                throw new IllegalStateException("The element here should be cue.");
            }
            this.cuePoints = this.parseCues(cuesElement);
        }
        if (this.cuePoints != null && (cuePoint = this.lastCueNotAfterTimecode(timecode)) != null && cuePoint.trackClusterOffsets[trackId] >= 0L) {
            this.reader.seek(this.segmentElementPosition + cuePoint.trackClusterOffsets[trackId]);
            return;
        }
        this.reader.seek(this.firstClusterElement.position);
    }

    private MatroskaCuePoint lastCueNotAfterTimecode(long timecode) {
        int largerTimecodeIndex;
        for (largerTimecodeIndex = 0; largerTimecodeIndex < this.cuePoints.size() && this.cuePoints.get((int)largerTimecodeIndex).timecode <= timecode; ++largerTimecodeIndex) {
        }
        if (largerTimecodeIndex > 0) {
            return this.cuePoints.get(largerTimecodeIndex - 1);
        }
        return null;
    }

    public void provideFrames(MatroskaTrackConsumer consumer) throws InterruptedException {
        try {
            MatroskaElement child;
            long position = this.reader.getPosition();
            MatroskaElement matroskaElement = child = position == this.firstClusterElement.getDataPosition() ? this.firstClusterElement : this.reader.readNextElement(null);
            while (child != null) {
                if (child.is(MatroskaElementType.Cluster)) {
                    this.parseNextCluster(child, consumer);
                }
                this.reader.skip(child);
                if (this.reader.getPosition() < this.segmentEndPosition) {
                    child = this.reader.readNextElement(null);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void parseNextCluster(MatroskaElement clusterElement, MatroskaTrackConsumer consumer) throws InterruptedException, IOException {
        MatroskaElement child;
        long clusterTimecode = 0L;
        while ((child = this.reader.readNextElement(clusterElement)) != null) {
            if (child.is(MatroskaElementType.Timecode)) {
                clusterTimecode = this.reader.asLong(child);
            } else if (child.is(MatroskaElementType.SimpleBlock)) {
                this.parseClusterSimpleBlock(child, consumer, clusterTimecode);
            } else if (child.is(MatroskaElementType.BlockGroup)) {
                this.parseClusterBlockGroup(child, consumer, clusterTimecode);
            }
            this.reader.skip(child);
        }
    }

    private void parseClusterSimpleBlock(MatroskaElement simpleBlock, MatroskaTrackConsumer consumer, long clusterTimecode) throws InterruptedException, IOException {
        MatroskaFixedBlock block = new MatroskaFixedBlock(ByteBuffer.wrap(this.reader.asBytes(simpleBlock)));
        block.parseHeader();
        this.processFrameInBlock(block, consumer, clusterTimecode);
    }

    private void parseClusterBlockGroup(MatroskaElement blockGroup, MatroskaTrackConsumer consumer, long clusterTimecode) throws InterruptedException, IOException {
        MatroskaElement child;
        MatroskaFixedBlock block = null;
        while ((child = this.reader.readNextElement(blockGroup)) != null) {
            if (child.is(MatroskaElementType.Block)) {
                block = new MatroskaFixedBlock(ByteBuffer.wrap(this.reader.asBytes(child)));
                block.parseHeader();
            }
            this.reader.skip(child);
        }
        if (block == null) {
            throw new NullPointerException("BlockGroup element with no child Block!");
        }
        this.processFrameInBlock(block, consumer, clusterTimecode);
    }

    private void processFrameInBlock(MatroskaFixedBlock block, MatroskaTrackConsumer consumer, long clusterTimecode) throws InterruptedException {
        if (consumer.getTrack().index != block.getTrackNumber()) {
            return;
        }
        long timecode = clusterTimecode + (long)block.getTimecode();
        if (timecode >= this.minimumTimecode) {
            int frameCount = block.getFrameCount();
            if (this.seeking) {
                consumer.seekPerformed(this.minimumTimecode, timecode);
                this.seeking = false;
            }
            for (int i = 0; i < frameCount; ++i) {
                consumer.consume(block.getFrameBuffer(i));
            }
        }
    }

    private void parseSegmentInfo(MatroskaElement infoElement) throws IOException {
        MatroskaElement child;
        while ((child = this.reader.readNextElement(infoElement)) != null) {
            if (child.is(MatroskaElementType.Duration)) {
                this.duration = this.reader.asDouble(child);
            } else if (child.is(MatroskaElementType.TimecodeScale)) {
                this.timecodeScale = this.reader.asLong(child);
            }
            this.reader.skip(child);
        }
    }

    private void parseTracks(MatroskaElement tracksElement) throws IOException {
        MatroskaElement child;
        while ((child = this.reader.readNextElement(tracksElement)) != null) {
            if (child.is(MatroskaElementType.TrackEntry)) {
                this.trackList.add(MatroskaFileTrack.parse(child, this.reader));
            }
            this.reader.skip(child);
        }
    }
}

