/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.chatterbotapi;

import com.google.code.chatterbotapi.ChatterBot;
import com.google.code.chatterbotapi.ChatterBotSession;
import com.google.code.chatterbotapi.ChatterBotThought;
import com.google.code.chatterbotapi.Utils;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

class Pandorabots
implements ChatterBot {
    private final String botid;

    public Pandorabots(String botid) {
        this.botid = botid;
    }

    @Override
    public ChatterBotSession createSession(Locale ... locales) {
        return new Session();
    }

    private class Session
    implements ChatterBotSession {
        private final Map<String, String> vars = new LinkedHashMap<String, String>();

        public Session() {
            this.vars.put("botid", Pandorabots.this.botid);
            this.vars.put("custid", UUID.randomUUID().toString());
        }

        @Override
        public ChatterBotThought think(ChatterBotThought thought) throws Exception {
            this.vars.put("input", thought.getText());
            String response = Utils.request("https://www.pandorabots.com/pandora/talk-xml", null, null, this.vars);
            ChatterBotThought responseThought = new ChatterBotThought();
            responseThought.setText(Utils.xPathSearch(response, "//result/that/text()"));
            return responseThought;
        }

        @Override
        public String think(String text) throws Exception {
            ChatterBotThought thought = new ChatterBotThought();
            thought.setText(text);
            return this.think(thought).getText();
        }
    }
}

