/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import me.iblitzkriegi.vixio.org.apache.http.util.Args;

public class IOUtil {
    public static byte[] readFully(File file) throws IOException {
        Args.notNull(file, "File");
        Args.check(file.exists(), "Provided file does not exist!");
        try (FileInputStream is = new FileInputStream(file);){
            int offset;
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                throw new IOException("Cannot read the file into memory completely due to it being too large!");
            }
            byte[] bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
            ((InputStream)is).close();
            byte[] byArray = bytes;
            return byArray;
        }
    }

    public static byte[] readFully(InputStream stream) throws IOException {
        Args.notNull(stream, "InputStream");
        byte[] buffer = new byte[1024];
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int readAmount = 0;
            while ((readAmount = stream.read(buffer)) != -1) {
                bos.write(buffer, 0, readAmount);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }
}

