/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests.restaction;

import java.awt.Color;
import java.util.Collection;
import me.iblitzkriegi.vixio.org.apache.http.util.Args;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.exceptions.PermissionException;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import org.json.JSONObject;

public class RoleAction
extends RestAction<Role> {
    protected final Guild guild;
    protected long permissions = 0L;
    protected String name = null;
    protected Integer color = null;
    protected Boolean hoisted = null;
    protected Boolean mentionable = null;

    public RoleAction(Route.CompiledRoute route, Guild guild) {
        super(guild.getJDA(), route, null);
        this.guild = guild;
    }

    public RoleAction setName(String name) {
        this.name = name;
        return this;
    }

    public RoleAction setHoisted(Boolean hoisted) {
        this.hoisted = hoisted;
        return this;
    }

    public RoleAction setMentionable(Boolean mentionable) {
        this.mentionable = mentionable;
        return this;
    }

    public RoleAction setColor(Color color) {
        return this.setColor(color != null ? Integer.valueOf(color.getRGB()) : null);
    }

    public RoleAction setColor(Integer rgb) {
        this.color = rgb;
        return this;
    }

    public RoleAction setPermissions(Permission ... permissions) {
        if (permissions != null) {
            for (Permission p : permissions) {
                Args.notNull(p, "Permissions");
                this.checkPermission(p);
            }
        }
        this.permissions = permissions == null ? 0L : Permission.getRaw(permissions);
        return this;
    }

    public RoleAction setPermissions(Collection<Permission> permissions) {
        if (permissions != null) {
            for (Permission p : permissions) {
                Args.notNull(p, "Permissions");
                this.checkPermission(p);
            }
        }
        this.permissions = permissions == null ? 0L : Permission.getRaw(permissions);
        return this;
    }

    public RoleAction setPermissions(long permissions) {
        Args.notNegative(permissions, "Raw Permissions");
        Args.check(permissions <= Permission.ALL_PERMISSIONS, "Provided permissions may not be greater than a full permission set!");
        for (Permission p : Permission.getPermissions(permissions)) {
            this.checkPermission(p);
        }
        this.permissions = permissions;
        return this;
    }

    @Override
    protected void finalizeData() {
        JSONObject object = new JSONObject();
        if (this.name != null) {
            object.put("name", this.name);
        }
        if (this.color != null) {
            object.put("color", (int)(this.color & 0xFFFFFF));
        }
        if (this.permissions > 0L) {
            object.put("permissions", this.permissions);
        }
        if (this.hoisted != null) {
            object.put("hoist", this.hoisted);
        }
        if (this.mentionable != null) {
            object.put("mentionable", this.mentionable);
        }
        this.data = object;
        super.finalizeData();
    }

    @Override
    protected void handleResponse(Response response, Request request) {
        if (response.isOk()) {
            request.onSuccess(EntityBuilder.get(this.api).createRole(response.getObject(), this.guild.getId()));
        } else {
            request.onFailure(response);
        }
    }

    private void checkPermission(Permission permission) {
        if (!this.guild.getSelfMember().hasPermission(permission)) {
            throw new PermissionException(permission);
        }
    }
}

