/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests.restaction;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import me.iblitzkriegi.vixio.org.apache.http.util.Args;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONString;

public class ChannelAction
extends RestAction<Channel> {
    public static final int ROLE_TYPE = 0;
    public static final int MEMBER_TYPE = 1;
    protected final Set<PromisePermissionOverride> overrides = new HashSet<PromisePermissionOverride>();
    protected final Guild guild;
    protected final boolean voice;
    protected String name;
    protected String topic = null;
    protected Integer bitrate = null;
    protected Integer userlimit = null;

    public ChannelAction(Route.CompiledRoute route, String name, Guild guild, boolean voice) {
        super(guild.getJDA(), route, null);
        this.guild = guild;
        this.voice = voice;
        this.name = name;
    }

    public ChannelAction setName(String name) {
        Args.notNull(name, "Channel name");
        if (name.length() < 2 || name.length() > 100) {
            throw new IllegalArgumentException("Provided channel name must be 2 to 100 characters in length");
        }
        this.name = name;
        return this;
    }

    public ChannelAction setTopic(String topic) {
        if (this.voice) {
            throw new UnsupportedOperationException("Cannot set the topic for a VoiceChannel!");
        }
        if (topic != null && topic.length() > 1024) {
            throw new IllegalArgumentException("Channel Topic must not be greater than 1024 in length!");
        }
        this.topic = topic;
        return this;
    }

    public ChannelAction addPermissionOverride(Role role, Collection<Permission> allow, Collection<Permission> deny) {
        this.checkPermissions(allow);
        this.checkPermissions(deny);
        long allowRaw = allow != null ? Permission.getRaw(allow) : 0L;
        long denyRaw = deny != null ? Permission.getRaw(deny) : 0L;
        return this.addPermissionOverride(role, allowRaw, denyRaw);
    }

    public ChannelAction addPermissionOverride(Member member, Collection<Permission> allow, Collection<Permission> deny) {
        this.checkPermissions(allow);
        this.checkPermissions(deny);
        long allowRaw = allow != null ? Permission.getRaw(allow) : 0L;
        long denyRaw = deny != null ? Permission.getRaw(deny) : 0L;
        return this.addPermissionOverride(member, allowRaw, denyRaw);
    }

    public ChannelAction addPermissionOverride(Role role, long allow, long deny) {
        Args.notNull(role, "Override Role");
        Args.notNegative(allow, "Granted permissions value");
        Args.notNegative(deny, "Denied permissions value");
        Args.check(allow <= Permission.ALL_PERMISSIONS, "Specified allow value may not be greater than a full permission set");
        Args.check(deny <= Permission.ALL_PERMISSIONS, "Specified deny value may not be greater than a full permission set");
        Args.check(role.getGuild().equals(this.guild), "Specified Role is not in the same Guild!");
        String id = role.getId();
        this.overrides.add(new PromisePermissionOverride(0, id, allow, deny));
        return this;
    }

    public ChannelAction addPermissionOverride(Member member, long allow, long deny) {
        Args.notNull(member, "Override Member");
        Args.notNegative(allow, "Granted permissions value");
        Args.notNegative(deny, "Denied permissions value");
        Args.check(allow <= Permission.ALL_PERMISSIONS, "Specified allow value may not be greater than a full permission set");
        Args.check(deny <= Permission.ALL_PERMISSIONS, "Specified deny value may not be greater than a full permission set");
        Args.check(member.getGuild().equals(this.guild), "Specified Member is not in the same Guild!");
        String id = member.getUser().getId();
        this.overrides.add(new PromisePermissionOverride(1, id, allow, deny));
        return this;
    }

    public ChannelAction setBitrate(Integer bitrate) {
        if (!this.voice) {
            throw new UnsupportedOperationException("Cannot set the bitrate for a TextChannel!");
        }
        if (bitrate != null) {
            if (bitrate < 8000) {
                throw new IllegalArgumentException("Bitrate must be greater than 8000.");
            }
            if (bitrate > 128000) {
                throw new IllegalArgumentException("Bitrate must be less than 128000.");
            }
        }
        this.bitrate = bitrate;
        return this;
    }

    public ChannelAction setUserlimit(Integer userlimit) {
        if (!this.voice) {
            throw new UnsupportedOperationException("Cannot set the userlimit for a TextChannel!");
        }
        if (userlimit != null && (userlimit < 0 || userlimit > 99)) {
            throw new IllegalArgumentException("Userlimit must be between 0-99!");
        }
        this.userlimit = userlimit;
        return this;
    }

    @Override
    protected void finalizeData() {
        JSONObject data = new JSONObject();
        data.put("name", this.name);
        data.put("type", this.voice ? 2 : 0);
        data.put("permission_overwrites", new JSONArray(this.overrides));
        if (this.voice) {
            if (this.bitrate != null) {
                data.put("bitrate", this.bitrate);
            }
            if (this.userlimit != null) {
                data.put("user_limit", this.userlimit);
            }
        }
        this.data = data;
        super.finalizeData();
    }

    @Override
    protected void handleResponse(Response response, Request request) {
        if (!response.isOk()) {
            request.onFailure(response);
            return;
        }
        EntityBuilder builder = EntityBuilder.get(this.api);
        Comparable<VoiceChannel> channel = this.voice ? builder.createVoiceChannel(response.getObject(), this.guild.getId()) : builder.createTextChannel(response.getObject(), this.guild.getId());
        request.onSuccess(channel);
    }

    protected void checkPermissions(Permission ... permissions) {
        if (permissions == null) {
            return;
        }
        for (Permission p : permissions) {
            Args.notNull(p, "Permissions");
        }
    }

    protected void checkPermissions(Collection<Permission> permissions) {
        if (permissions == null) {
            return;
        }
        for (Permission p : permissions) {
            Args.notNull(p, "Permissions");
        }
    }

    protected final class PromisePermissionOverride
    implements JSONString {
        protected final String id;
        protected final long deny;
        protected final long allow;
        protected final int type;

        public PromisePermissionOverride(int type, String id, long allow, long deny) {
            this.type = type;
            this.id = id;
            this.deny = deny;
            this.allow = allow;
        }

        @Override
        public String toJSONString() {
            JSONObject object = new JSONObject();
            object.put("id", this.id);
            object.put("type", this.type);
            object.put("deny", this.deny);
            object.put("allow", this.allow);
            return object.toString();
        }
    }
}

