/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.requests;

import com.mashape.unirest.http.HttpResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Requester;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.ratelimit.IBucket;

public abstract class RateLimiter {
    protected final Requester requester;
    protected final ScheduledExecutorService pool;
    protected volatile boolean isShutdown;
    protected volatile ConcurrentHashMap<String, IBucket> buckets = new ConcurrentHashMap();
    protected volatile ConcurrentLinkedQueue<IBucket> submittedBuckets = new ConcurrentLinkedQueue();

    protected RateLimiter(Requester requester, int poolSize) {
        this.requester = requester;
        this.isShutdown = false;
        this.pool = Executors.newScheduledThreadPool(poolSize, new RateLimitThreadFactory(requester.getJDA()));
    }

    public abstract Long getRateLimit(Route.CompiledRoute var1);

    protected abstract void queueRequest(Request var1);

    protected abstract Long handleResponse(Route.CompiledRoute var1, HttpResponse<String> var2);

    public boolean isRateLimited(Route.CompiledRoute route) {
        return this.getRateLimit(route) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IBucket> getRouteBuckets() {
        ConcurrentHashMap<String, IBucket> concurrentHashMap = this.buckets;
        synchronized (concurrentHashMap) {
            return Collections.unmodifiableList(new ArrayList<IBucket>(this.buckets.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IBucket> getQueuedRouteBuckets() {
        ConcurrentLinkedQueue<IBucket> concurrentLinkedQueue = this.submittedBuckets;
        synchronized (concurrentLinkedQueue) {
            return Collections.unmodifiableList(new ArrayList<IBucket>(this.submittedBuckets));
        }
    }

    protected void shutdown() {
        this.isShutdown = true;
        try {
            while (!this.submittedBuckets.isEmpty()) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.pool.shutdownNow();
    }

    protected List<IBucket> shutdownNow() {
        this.isShutdown = true;
        this.pool.shutdownNow();
        try {
            while (!this.pool.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.buckets.values().stream().filter(b -> !b.getRequests().isEmpty()).collect(Collectors.toList());
    }

    private class RateLimitThreadFactory
    implements ThreadFactory {
        final String identifier;
        AtomicInteger threadCount = new AtomicInteger(1);

        public RateLimitThreadFactory(JDAImpl api) {
            this.identifier = api.getIdentifierString() + " RateLimit-Queue Pool";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, this.identifier + " - Thread " + this.threadCount.getAndIncrement());
            t.setDaemon(true);
            return t;
        }
    }
}

