/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.managers;

import java.util.regex.Pattern;
import me.iblitzkriegi.vixio.org.apache.http.util.Args;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.Icon;
import net.dv8tion.jda.core.entities.SelfUser;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.exceptions.AccountTypeException;
import net.dv8tion.jda.core.managers.fields.AccountField;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import org.json.JSONObject;

public class AccountManagerUpdatable {
    public static final Pattern EMAIL_PATTERN = Pattern.compile(".+@.+");
    protected final SelfUser selfUser;
    protected AccountField<String> name;
    protected AccountField<Icon> avatar;
    protected AccountField<String> email;
    protected AccountField<String> password;

    public AccountManagerUpdatable(SelfUser selfUser) {
        this.selfUser = selfUser;
        this.setupFields();
    }

    public JDA getJDA() {
        return this.selfUser.getJDA();
    }

    public SelfUser getSelfUser() {
        return this.selfUser;
    }

    public AccountField<String> getNameField() {
        return this.name;
    }

    public AccountField<Icon> getAvatarField() {
        return this.avatar;
    }

    public AccountField<String> getEmailField() {
        if (!this.isType(AccountType.CLIENT)) {
            throw new AccountTypeException(AccountType.CLIENT);
        }
        return this.email;
    }

    public AccountField<String> getPasswordField() {
        if (!this.isType(AccountType.CLIENT)) {
            throw new AccountTypeException(AccountType.CLIENT);
        }
        return this.password;
    }

    public void reset() {
        this.name.reset();
        this.avatar.reset();
        if (this.isType(AccountType.CLIENT)) {
            this.email.reset();
            this.password.reset();
        }
    }

    public RestAction<Void> update(String currentPassword) {
        if (this.isType(AccountType.CLIENT) && (currentPassword == null || currentPassword.isEmpty())) {
            throw new IllegalArgumentException("Provided client account password to be used in auth is null or empty!");
        }
        if (!this.needToUpdate()) {
            return new RestAction.EmptyRestAction<Object>(null);
        }
        JSONObject body = new JSONObject();
        body.put("username", this.name.getOriginalValue());
        body.put("avatar", this.selfUser.getAvatarId() != null ? this.selfUser.getAvatarId() : JSONObject.NULL);
        if (this.name.shouldUpdate()) {
            body.put("username", this.name.getValue());
        }
        if (this.avatar.shouldUpdate()) {
            body.put("avatar", this.avatar.getValue() != null ? ((Icon)this.avatar.getValue()).getEncoding() : JSONObject.NULL);
        }
        if (this.isType(AccountType.CLIENT)) {
            body.put("password", currentPassword);
            body.put("email", this.email.getOriginalValue());
            if (this.email.shouldUpdate()) {
                body.put("email", this.email.getValue());
            }
            if (this.password.shouldUpdate()) {
                body.put("new_password", this.password.getValue());
            }
        }
        this.reset();
        Route.CompiledRoute route = Route.Self.MODIFY_SELF.compile(new String[0]);
        return new RestAction<Void>(this.getJDA(), route, (Object)body){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                String newToken = response.getObject().getString("token");
                newToken = newToken.replace("Bot ", "");
                ((JDAImpl)this.getJDA()).setToken(newToken);
                request.onSuccess(null);
            }
        };
    }

    public RestAction<Void> update() {
        if (this.getJDA().getAccountType() == AccountType.CLIENT) {
            throw new AccountTypeException(AccountType.BOT);
        }
        return this.update(null);
    }

    protected boolean needToUpdate() {
        return this.name.shouldUpdate() || this.avatar.shouldUpdate() || this.isType(AccountType.CLIENT) && this.email.shouldUpdate() || this.isType(AccountType.CLIENT) && this.password.shouldUpdate();
    }

    protected void setupFields() {
        this.name = new AccountField<String>(this, this.selfUser::getName){

            @Override
            public void checkValue(String value) {
                Args.notNull(value, "account name");
                if (value.length() < 2 || value.length() > 32) {
                    throw new IllegalArgumentException("Provided name must be 2 to 32 characters in length");
                }
            }
        };
        this.avatar = new AccountField<Icon>(this, null){

            @Override
            public void checkValue(Icon value) {
            }

            @Override
            public Icon getOriginalValue() {
                throw new UnsupportedOperationException("Cannot easily provide the original Avatar. Use User#getIconUrl() and download it yourself.");
            }

            @Override
            public boolean shouldUpdate() {
                return this.isSet();
            }
        };
        if (this.isType(AccountType.CLIENT)) {
            this.email = new AccountField<String>(this, this.selfUser::getEmail){

                @Override
                public void checkValue(String value) {
                    Args.notNull(value, "account email");
                    if (!EMAIL_PATTERN.matcher(value).find()) {
                        throw new IllegalArgumentException("Provided email is in invalid format. Provided value: " + value);
                    }
                }
            };
            this.password = new AccountField<String>(this, null){

                @Override
                public void checkValue(String value) {
                    Args.notNull(value, "account password");
                    if (value.length() < 6 || value.length() > 128) {
                        throw new IllegalArgumentException("Provided password must ben 6 to 128 characters in length");
                    }
                }

                @Override
                public String getOriginalValue() {
                    throw new UnsupportedOperationException("Cannot get the original password. We are not given this information.");
                }

                @Override
                public boolean shouldUpdate() {
                    return this.isSet();
                }
            };
        }
    }

    private boolean isType(AccountType type) {
        return this.getJDA().getAccountType() == type;
    }
}

