/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import com.neovisionaries.ws.client.WebSocketException;
import java.io.IOException;
import net.dv8tion.jda.core.audio.AudioConnection;
import net.dv8tion.jda.core.audio.AudioWebSocket;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.managers.impl.AudioManagerImpl;
import net.dv8tion.jda.core.requests.GuildLock;
import net.dv8tion.jda.core.requests.WebSocketClient;
import org.json.JSONObject;

public class VoiceServerUpdateHandler
extends SocketHandler {
    public VoiceServerUpdateHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        String guildId = content.getString("guild_id");
        this.api.getClient().getQueuedAudioConnectionMap().remove(guildId);
        if (GuildLock.get(this.api).isLocked(guildId)) {
            return guildId;
        }
        if (content.isNull("endpoint")) {
            return null;
        }
        String endpoint = content.getString("endpoint");
        String token = content.getString("token");
        Guild guild = this.api.getGuildMap().get(content.getString("guild_id"));
        if (guild == null) {
            throw new IllegalArgumentException("Attempted to start audio connection with Guild that doesn't exist! JSON: " + content);
        }
        String sessionId = guild.getSelfMember().getVoiceState().getSessionId();
        if (sessionId == null) {
            throw new IllegalArgumentException("Attempted to create audio connection without having a session ID. Did VOICE_STATE_UPDATED fail?");
        }
        endpoint = endpoint.replace(":80", "");
        AudioManagerImpl audioManager = (AudioManagerImpl)guild.getAudioManager();
        if (audioManager.isConnected()) {
            audioManager.prepareForRegionChange();
        }
        if (!audioManager.isAttemptingToConnect()) {
            WebSocketClient.LOG.debug("Received a VOICE_SERVER_UPDATE but JDA is not currently connected nor attempted to connect to a VoiceChannel. Assuming that this is caused by another client running on this account. Ignoring the event.");
            return null;
        }
        try {
            AudioWebSocket socket = new AudioWebSocket(audioManager.getListenerProxy(), endpoint, this.api, guild, sessionId, token, audioManager.isAutoReconnect());
            AudioConnection connection = new AudioConnection(socket, audioManager.getQueuedAudioConnection());
            audioManager.setAudioConnection(connection);
        }
        catch (WebSocketException | IOException exception) {
            // empty catch block
        }
        return null;
    }
}

