/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.MessageChannel;
import net.dv8tion.jda.core.entities.MessageReaction;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.impl.EmoteImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.events.message.react.MessageReactionAddEvent;
import net.dv8tion.jda.core.events.message.react.MessageReactionRemoveEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.requests.WebSocketClient;
import org.json.JSONObject;

public class MessageReactionHandler
extends SocketHandler {
    private final boolean add;

    public MessageReactionHandler(JDAImpl api, boolean add) {
        super(api);
        this.add = add;
    }

    @Override
    protected String handleInternally(JSONObject content) {
        MessageReaction.ReactionEmote rEmote;
        String emojiName;
        JSONObject emoji = content.getJSONObject("emoji");
        String userId = content.getString("user_id");
        String messageId = content.getString("message_id");
        String channelId = content.getString("channel_id");
        String emojiId = emoji.isNull("id") ? null : emoji.getString("id");
        String string = emojiName = emoji.isNull("name") ? null : emoji.getString("name");
        if (emojiId == null && emojiName == null) {
            WebSocketClient.LOG.debug("Received a reaction " + (this.add ? "add" : "remove") + " with no name nor id. json: " + content);
            return null;
        }
        User user = this.api.getUserById(userId);
        if (user == null) {
            user = this.api.getFakeUserMap().get(userId);
        }
        if (user == null) {
            EventCache.get(this.api).cache(EventCache.Type.USER, userId, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Received a reaction for a user that JDA does not currently have cached");
            return null;
        }
        MessageChannel channel = this.api.getTextChannelById(channelId);
        if (channel == null) {
            channel = this.api.getPrivateChannelById(channelId);
        }
        if (channel == null && this.api.getAccountType() == AccountType.CLIENT) {
            channel = this.api.asClient().getGroupById(channelId);
        }
        if (channel == null) {
            channel = this.api.getFakePrivateChannelMap().get(channelId);
        }
        if (channel == null) {
            EventCache.get(this.api).cache(EventCache.Type.CHANNEL, channelId, () -> this.handle(this.responseNumber, this.allContent));
            EventCache.LOG.debug("Received a reaction for a channel that JDA does not currently have cached");
            return null;
        }
        if (emojiId != null) {
            Emote emote = this.api.getEmoteById(emojiId);
            if (emote == null) {
                if (emojiName != null) {
                    emote = new EmoteImpl(emojiId, this.api).setName(emojiName);
                } else {
                    WebSocketClient.LOG.debug("Received a reaction " + (this.add ? "add" : "remove") + " with a null name. json: " + content);
                    return null;
                }
            }
            rEmote = new MessageReaction.ReactionEmote(emote);
        } else {
            rEmote = new MessageReaction.ReactionEmote(emojiName, null, this.api);
        }
        MessageReaction reaction = new MessageReaction(channel, rEmote, messageId, user.equals(this.api.getSelfUser()), -1);
        if (this.add) {
            this.api.getEventManager().handle(new MessageReactionAddEvent(this.api, this.responseNumber, user, reaction));
        } else {
            this.api.getEventManager().handle(new MessageReactionRemoveEvent(this.api, this.responseNumber, user, reaction));
        }
        return null;
    }
}

