/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import net.dv8tion.jda.client.entities.Group;
import net.dv8tion.jda.client.entities.Relationship;
import net.dv8tion.jda.client.entities.RelationshipType;
import net.dv8tion.jda.client.entities.impl.JDAClientImpl;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.audio.hooks.ConnectionStatus;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.entities.impl.PrivateChannelImpl;
import net.dv8tion.jda.core.entities.impl.UserImpl;
import net.dv8tion.jda.core.events.guild.GuildLeaveEvent;
import net.dv8tion.jda.core.events.guild.GuildUnavailableEvent;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.managers.impl.AudioManagerImpl;
import net.dv8tion.jda.core.requests.GuildLock;
import org.json.JSONObject;

public class GuildDeleteHandler
extends SocketHandler {
    public GuildDeleteHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        if (GuildLock.get(this.api).isLocked(content.getString("id"))) {
            return content.getString("id");
        }
        GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(content.getString("id"));
        AudioManagerImpl manager = (AudioManagerImpl)this.api.getAudioManagerMap().get(guild.getId());
        if (manager != null) {
            manager.closeAudioConnection(ConnectionStatus.DISCONNECTED_REMOVED_FROM_GUILD);
        }
        if (content.has("unavailable") && content.getBoolean("unavailable")) {
            guild.setAvailable(false);
            this.api.getEventManager().handle(new GuildUnavailableEvent(this.api, this.responseNumber, guild));
            return null;
        }
        if (manager != null) {
            this.api.getAudioManagerMap().remove(guild.getId());
        }
        Set<String> memberIds = guild.getMembersMap().keySet();
        for (Guild guildI : this.api.getGuilds()) {
            GuildImpl g = (GuildImpl)guildI;
            if (g.equals(guild)) continue;
            Iterator<String> it = memberIds.iterator();
            while (it.hasNext()) {
                if (!g.getMembersMap().containsKey(it.next())) continue;
                it.remove();
            }
        }
        if (this.api.getAccountType() == AccountType.CLIENT) {
            HashMap<String, Relationship> relationships = ((JDAClientImpl)this.api.asClient()).getRelationshipMap();
            Iterator<String> it = memberIds.iterator();
            while (it.hasNext()) {
                Relationship rel = relationships.get(it.next());
                if (rel == null || rel.getType() != RelationshipType.FRIEND) continue;
                it.remove();
            }
        }
        block3: for (String memberId : memberIds) {
            UserImpl user = (UserImpl)this.api.getUserMap().remove(memberId);
            if (user.hasPrivateChannel()) {
                PrivateChannelImpl priv = (PrivateChannelImpl)user.getPrivateChannel();
                user.setFake(true);
                priv.setFake(true);
                this.api.getFakeUserMap().put(user.getId(), user);
                this.api.getFakePrivateChannelMap().put(priv.getId(), priv);
                continue;
            }
            if (this.api.getAccountType() != AccountType.CLIENT) continue;
            for (Group grp : this.api.asClient().getGroups()) {
                if (!grp.getNonFriendUsers().contains(user)) continue;
                user.setFake(true);
                this.api.getFakeUserMap().put(user.getId(), user);
                continue block3;
            }
        }
        this.api.getGuildMap().remove(guild.getId());
        guild.getTextChannels().forEach(chan -> this.api.getTextChannelMap().remove(chan.getId()));
        guild.getVoiceChannels().forEach(chan -> this.api.getVoiceChannelMap().remove(chan.getId()));
        this.api.getEventManager().handle(new GuildLeaveEvent(this.api, this.responseNumber, guild));
        return null;
    }
}

