/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.handle;

import net.dv8tion.jda.client.entities.impl.GroupImpl;
import net.dv8tion.jda.client.entities.impl.JDAClientImpl;
import net.dv8tion.jda.client.events.group.GroupLeaveEvent;
import net.dv8tion.jda.core.audio.hooks.ConnectionStatus;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.PrivateChannel;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.VoiceChannel;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.entities.impl.UserImpl;
import net.dv8tion.jda.core.events.channel.priv.PrivateChannelDeleteEvent;
import net.dv8tion.jda.core.events.channel.text.TextChannelDeleteEvent;
import net.dv8tion.jda.core.events.channel.voice.VoiceChannelDeleteEvent;
import net.dv8tion.jda.core.handle.EventCache;
import net.dv8tion.jda.core.handle.SocketHandler;
import net.dv8tion.jda.core.managers.impl.AudioManagerImpl;
import net.dv8tion.jda.core.requests.GuildLock;
import org.json.JSONObject;

public class ChannelDeleteHandler
extends SocketHandler {
    public ChannelDeleteHandler(JDAImpl api) {
        super(api);
    }

    @Override
    protected String handleInternally(JSONObject content) {
        ChannelType type = ChannelType.fromId(content.getInt("type"));
        if ((type == ChannelType.TEXT || type == ChannelType.VOICE) && GuildLock.get(this.api).isLocked(content.getString("guild_id"))) {
            return content.getString("guild_id");
        }
        switch (type) {
            case TEXT: {
                GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(content.getString("guild_id"));
                TextChannel channel = this.api.getTextChannelMap().remove(content.getString("id"));
                if (channel == null) {
                    EventCache.get(this.api).cache(EventCache.Type.CHANNEL, content.getString("id"), () -> this.handle(this.responseNumber, this.allContent));
                    EventCache.LOG.debug("CHANNEL_DELETE attempted to delete a text channel that is not yet cached. JSON: " + content);
                    return null;
                }
                guild.getTextChannelsMap().remove(channel.getId());
                this.api.getEventManager().handle(new TextChannelDeleteEvent(this.api, this.responseNumber, channel));
                break;
            }
            case VOICE: {
                GuildImpl guild = (GuildImpl)this.api.getGuildMap().get(content.getString("guild_id"));
                VoiceChannel channel = guild.getVoiceChannelMap().remove(content.getString("id"));
                if (channel == null) {
                    EventCache.get(this.api).cache(EventCache.Type.CHANNEL, content.getString("id"), () -> this.handle(this.responseNumber, this.allContent));
                    EventCache.LOG.debug("CHANNEL_DELETE attempted to delete a voice channel that is not yet cached. JSON: " + content);
                    return null;
                }
                AudioManagerImpl manager = (AudioManagerImpl)this.api.getAudioManagerMap().get(guild.getId());
                if (manager != null && manager.isConnected() && manager.getConnectedChannel().getId().equals(channel.getId())) {
                    manager.closeAudioConnection(ConnectionStatus.DISCONNECTED_CHANNEL_DELETED);
                }
                guild.getVoiceChannelMap().remove(channel.getId());
                this.api.getEventManager().handle(new VoiceChannelDeleteEvent(this.api, this.responseNumber, channel));
                break;
            }
            case PRIVATE: {
                String channelId = content.getString("id");
                PrivateChannel channel = this.api.getPrivateChannelMap().remove(channelId);
                if (channel == null) {
                    channel = this.api.getFakePrivateChannelMap().remove(channelId);
                }
                if (channel == null) {
                    EventCache.get(this.api).cache(EventCache.Type.CHANNEL, content.getString("id"), () -> this.handle(this.responseNumber, this.allContent));
                    EventCache.LOG.debug("CHANNEL_DELETE attempted to delete a private channel that is not yet cached. JSON: " + content);
                    return null;
                }
                if (channel.getUser().isFake()) {
                    this.api.getFakeUserMap().remove(channel.getUser().getId());
                }
                ((UserImpl)channel.getUser()).setPrivateChannel(null);
                this.api.getEventManager().handle(new PrivateChannelDeleteEvent(this.api, this.responseNumber, channel));
                break;
            }
            case GROUP: {
                String groupId = content.getString("id");
                GroupImpl group = (GroupImpl)((JDAClientImpl)this.api.asClient()).getGroupMap().remove(groupId);
                if (group == null) {
                    EventCache.get(this.api).cache(EventCache.Type.CHANNEL, content.getString("id"), () -> this.handle(this.responseNumber, this.allContent));
                    EventCache.LOG.debug("CHANNEL_DELETE attempted to delete a group that is not yet cached. JSON: " + content);
                    return null;
                }
                group.getUserMap().forEach((userId, user) -> {
                    if (user.isFake() && !user.hasPrivateChannel() && this.api.asClient().getRelationshipById((String)userId) == null && this.api.asClient().getGroups().stream().allMatch(g -> !g.getUsers().contains(user))) {
                        this.api.getFakeUserMap().remove(userId);
                    }
                });
                this.api.getEventManager().handle(new GroupLeaveEvent(this.api, this.responseNumber, group));
                break;
            }
            default: {
                throw new IllegalArgumentException("CHANNEL_DELETE provided an unknown channel type. JSON: " + content);
            }
        }
        return null;
    }
}

