/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities.impl;

import java.io.InputStream;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import me.iblitzkriegi.vixio.org.apache.http.util.Args;
import net.dv8tion.jda.client.exceptions.VerificationLevelException;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.ISnowflake;
import net.dv8tion.jda.core.entities.Invite;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.entities.MessageHistory;
import net.dv8tion.jda.core.entities.PermissionOverride;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.Webhook;
import net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.exceptions.PermissionException;
import net.dv8tion.jda.core.managers.ChannelManager;
import net.dv8tion.jda.core.managers.ChannelManagerUpdatable;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.requests.restaction.InviteAction;
import net.dv8tion.jda.core.requests.restaction.PermissionOverrideAction;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TextChannelImpl
implements TextChannel {
    private final String id;
    private final GuildImpl guild;
    private final HashMap<Member, PermissionOverride> memberOverrides = new HashMap();
    private final HashMap<Role, PermissionOverride> roleOverrides = new HashMap();
    private volatile ChannelManager manager;
    private volatile ChannelManagerUpdatable managerUpdatable;
    private final Object mngLock = new Object();
    private String name;
    private String topic;
    private int rawPosition;

    public TextChannelImpl(String id, Guild guild) {
        this.id = id;
        this.guild = (GuildImpl)guild;
    }

    @Override
    public String getAsMention() {
        return "<#" + this.getId() + '>';
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public RestAction<Void> deleteMessages(Collection<Message> messages) {
        Args.notEmpty(messages, "Messages collection");
        return this.deleteMessagesByIds(messages.stream().map(ISnowflake::getId).collect(Collectors.toList()));
    }

    @Override
    public RestAction<Void> deleteMessagesByIds(Collection<String> messageIds) {
        this.checkPermission(Permission.MESSAGE_MANAGE, "Must have MESSAGE_MANAGE in order to bulk delete messages in this channel regardless of author.");
        if (messageIds.size() < 2 || messageIds.size() > 100) {
            throw new IllegalArgumentException("Must provide at least 2 or at most 100 messages to be deleted.");
        }
        long twoWeeksAgo = System.currentTimeMillis() - 1209600000L - 1420070400000L << 22;
        for (String id : messageIds) {
            Args.notEmpty(id, "Message id in messageIds");
            Args.check(Long.parseLong(id) > twoWeeksAgo, "Message Id provided was older than 2 weeks. Id: " + id);
        }
        JSONObject body = new JSONObject().put("messages", messageIds);
        Route.CompiledRoute route = Route.Messages.DELETE_MESSAGES.compile(this.id);
        return new RestAction<Void>(this.getJDA(), route, (Object)body){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<List<Webhook>> getWebhooks() {
        this.checkPermission(Permission.MANAGE_WEBHOOKS);
        Route.CompiledRoute route = Route.Channels.GET_WEBHOOKS.compile(this.id);
        return new RestAction<List<Webhook>>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                LinkedList<Webhook> webhooks = new LinkedList<Webhook>();
                JSONArray array = response.getArray();
                EntityBuilder builder = EntityBuilder.get(this.getJDA());
                for (Object object : array) {
                    try {
                        webhooks.add(builder.createWebhook((JSONObject)object));
                    }
                    catch (NullPointerException | JSONException e) {
                        JDAImpl.LOG.log(e);
                    }
                }
                request.onSuccess(webhooks);
            }
        };
    }

    @Override
    public RestAction<Void> deleteWebhookById(String id) {
        Args.notEmpty(id, "webhook id");
        if (!this.guild.getSelfMember().hasPermission((Channel)this, Permission.MANAGE_WEBHOOKS)) {
            throw new PermissionException(Permission.MANAGE_WEBHOOKS);
        }
        Route.CompiledRoute route = Route.Webhooks.DELETE_WEBHOOK.compile(id);
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public boolean canTalk() {
        return this.canTalk(this.guild.getSelfMember());
    }

    @Override
    public boolean canTalk(Member member) {
        if (!this.guild.equals(member.getGuild())) {
            throw new IllegalArgumentException("Provided Member is not from the Guild that this TextChannel is part of.");
        }
        return member.hasPermission((Channel)this, Permission.MESSAGE_READ, Permission.MESSAGE_WRITE);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ChannelType getType() {
        return ChannelType.TEXT;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public Guild getGuild() {
        return this.guild;
    }

    @Override
    public List<Member> getMembers() {
        return Collections.unmodifiableList(((GuildImpl)this.getGuild()).getMembersMap().values().stream().filter(m -> m.getPermissions(this).contains((Object)Permission.MESSAGE_READ)).collect(Collectors.toList()));
    }

    @Override
    public int getPosition() {
        List<TextChannel> channels = this.guild.getTextChannels();
        for (int i = 0; i < channels.size(); ++i) {
            if (channels.get(i) != this) continue;
            return i;
        }
        throw new RuntimeException("Somehow when determining position we never found the TextChannel in the Guild's channels? wtf?");
    }

    @Override
    public int getPositionRaw() {
        return this.rawPosition;
    }

    @Override
    public JDA getJDA() {
        return this.guild.getJDA();
    }

    @Override
    public RestAction<Message> sendMessage(Message msg) {
        Args.notNull(msg, "Message");
        this.checkVerification();
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_WRITE);
        if (msg.getRawContent().isEmpty() && !msg.getEmbeds().isEmpty()) {
            this.checkPermission(Permission.MESSAGE_EMBED_LINKS);
        }
        return TextChannel.super.sendMessage(msg);
    }

    @Override
    public RestAction<Message> sendFile(InputStream data, String fileName, Message message) {
        this.checkVerification();
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_WRITE);
        this.checkPermission(Permission.MESSAGE_ATTACH_FILES);
        return TextChannel.super.sendFile(data, fileName, message);
    }

    @Override
    public RestAction<Message> sendFile(byte[] data, String fileName, Message message) {
        this.checkVerification();
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_WRITE);
        this.checkPermission(Permission.MESSAGE_ATTACH_FILES);
        return TextChannel.super.sendFile(data, fileName, message);
    }

    @Override
    public RestAction<Message> getMessageById(String messageId) {
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_HISTORY);
        return TextChannel.super.getMessageById(messageId);
    }

    @Override
    public RestAction<Void> deleteMessageById(String messageId) {
        this.checkNull(messageId, "messageId");
        this.checkPermission(Permission.MESSAGE_READ);
        return TextChannel.super.deleteMessageById(messageId);
    }

    @Override
    public RestAction<MessageHistory> getHistoryAround(String messageId, int limit) {
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_HISTORY);
        return TextChannel.super.getHistoryAround(messageId, limit);
    }

    @Override
    public RestAction<Void> pinMessageById(String messageId) {
        this.checkPermission(Permission.MESSAGE_READ, "You cannot pin a message in a channel you can't access. (MESSAGE_READ)");
        this.checkPermission(Permission.MESSAGE_MANAGE, "You need MESSAGE_MANAGE to pin or unpin messages.");
        return TextChannel.super.pinMessageById(messageId);
    }

    @Override
    public RestAction<Void> unpinMessageById(String messageId) {
        this.checkPermission(Permission.MESSAGE_READ, "You cannot unpin a message in a channel you can't access. (MESSAGE_READ)");
        this.checkPermission(Permission.MESSAGE_MANAGE, "You need MESSAGE_MANAGE to pin or unpin messages.");
        return TextChannel.super.unpinMessageById(messageId);
    }

    @Override
    public RestAction<List<Message>> getPinnedMessages() {
        this.checkPermission(Permission.MESSAGE_READ, "Cannot get the pinned message of a channel without MESSAGE_READ access.");
        return TextChannel.super.getPinnedMessages();
    }

    @Override
    public RestAction<Void> addReactionById(String messageId, String unicode) {
        this.checkPermission(Permission.MESSAGE_ADD_REACTION);
        return TextChannel.super.addReactionById(messageId, unicode);
    }

    @Override
    public RestAction<Void> addReactionById(String messageId, Emote emote) {
        this.checkPermission(Permission.MESSAGE_ADD_REACTION);
        return TextChannel.super.addReactionById(messageId, emote);
    }

    @Override
    public PermissionOverride getPermissionOverride(Member member) {
        return this.memberOverrides.get(member);
    }

    @Override
    public PermissionOverride getPermissionOverride(Role role) {
        return this.roleOverrides.get(role);
    }

    @Override
    public List<PermissionOverride> getPermissionOverrides() {
        ArrayList<PermissionOverride> overrides = new ArrayList<PermissionOverride>(this.memberOverrides.size() + this.roleOverrides.size());
        overrides.addAll(this.memberOverrides.values());
        overrides.addAll(this.roleOverrides.values());
        return Collections.unmodifiableList(overrides);
    }

    @Override
    public List<PermissionOverride> getMemberPermissionOverrides() {
        return Collections.unmodifiableList(new ArrayList<PermissionOverride>(this.memberOverrides.values()));
    }

    @Override
    public List<PermissionOverride> getRolePermissionOverrides() {
        return Collections.unmodifiableList(new ArrayList<PermissionOverride>(this.roleOverrides.values()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelManager getManager() {
        ChannelManager mng = this.manager;
        if (mng == null) {
            Object object = this.mngLock;
            synchronized (object) {
                mng = this.manager;
                if (mng == null) {
                    mng = this.manager = new ChannelManager(this);
                }
            }
        }
        return mng;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChannelManagerUpdatable getManagerUpdatable() {
        ChannelManagerUpdatable mng = this.managerUpdatable;
        if (mng == null) {
            Object object = this.mngLock;
            synchronized (object) {
                mng = this.managerUpdatable;
                if (mng == null) {
                    mng = this.managerUpdatable = new ChannelManagerUpdatable(this);
                }
            }
        }
        return mng;
    }

    @Override
    public RestAction<Void> delete() {
        this.checkPermission(Permission.MANAGE_CHANNEL);
        Route.CompiledRoute route = Route.Channels.DELETE_CHANNEL.compile(this.id);
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<Message> editMessageById(String id, Message newContent) {
        Args.notNull(newContent, "Message");
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_WRITE);
        if (newContent.getRawContent().isEmpty() && !newContent.getEmbeds().isEmpty()) {
            this.checkPermission(Permission.MESSAGE_EMBED_LINKS);
        }
        return TextChannel.super.editMessageById(id, newContent);
    }

    @Override
    public PermissionOverrideAction createPermissionOverride(Member member) {
        this.checkPermission(Permission.MANAGE_PERMISSIONS);
        Args.notNull(member, "member");
        if (!this.guild.equals(member.getGuild())) {
            throw new IllegalArgumentException("Provided member is not from the same guild as this channel!");
        }
        if (this.getMemberOverrideMap().containsKey(member)) {
            throw new IllegalStateException("Provided member already has a PermissionOverride in this channel!");
        }
        Route.CompiledRoute route = Route.Channels.CREATE_PERM_OVERRIDE.compile(this.id, member.getUser().getId());
        return new PermissionOverrideAction(this.getJDA(), route, (Channel)this, member);
    }

    @Override
    public PermissionOverrideAction createPermissionOverride(Role role) {
        this.checkPermission(Permission.MANAGE_PERMISSIONS);
        Args.notNull(role, "role");
        if (!this.guild.equals(role.getGuild())) {
            throw new IllegalArgumentException("Provided role is not from the same guild as this channel!");
        }
        if (this.getRoleOverrideMap().containsKey(role)) {
            throw new IllegalStateException("Provided role already has a PermissionOverride in this channel!");
        }
        Route.CompiledRoute route = Route.Channels.CREATE_PERM_OVERRIDE.compile(this.id, role.getId());
        return new PermissionOverrideAction(this.getJDA(), route, (Channel)this, role);
    }

    public boolean equals(Object o) {
        if (!(o instanceof TextChannel)) {
            return false;
        }
        TextChannel oTChannel = (TextChannel)o;
        return this == oTChannel || this.getId().equals(oTChannel.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return "TC:" + this.getName() + '(' + this.getId() + ')';
    }

    @Override
    public int compareTo(TextChannel chan) {
        if (this == chan) {
            return 0;
        }
        if (this.getGuild() != chan.getGuild()) {
            throw new IllegalArgumentException("Cannot compare TextChannels that aren't from the same guild!");
        }
        if (this.getPositionRaw() != chan.getPositionRaw()) {
            return chan.getPositionRaw() - this.getPositionRaw();
        }
        OffsetDateTime thisTime = this.getCreationTime();
        OffsetDateTime chanTime = chan.getCreationTime();
        return chanTime.compareTo(thisTime);
    }

    public TextChannelImpl setName(String name) {
        this.name = name;
        return this;
    }

    public TextChannelImpl setTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public TextChannelImpl setRawPosition(int rawPosition) {
        this.rawPosition = rawPosition;
        return this;
    }

    public HashMap<Member, PermissionOverride> getMemberOverrideMap() {
        return this.memberOverrides;
    }

    public HashMap<Role, PermissionOverride> getRoleOverrideMap() {
        return this.roleOverrides;
    }

    private void checkVerification() {
        if (!this.guild.checkVerification()) {
            throw new VerificationLevelException(this.guild.getVerificationLevel());
        }
    }

    private void checkPermission(Permission permission) {
        this.checkPermission(permission, null);
    }

    private void checkPermission(Permission permission, String message) {
        if (!this.guild.getSelfMember().hasPermission((Channel)this, permission)) {
            if (message != null) {
                throw new PermissionException(permission, message);
            }
            throw new PermissionException(permission);
        }
    }

    private void checkNull(Object obj, String name) {
        if (obj == null) {
            throw new NullPointerException("Provided " + name + " was null!");
        }
    }

    @Override
    public RestAction<List<Invite>> getInvites() {
        if (!this.guild.getSelfMember().hasPermission((Channel)this, Permission.MANAGE_CHANNEL)) {
            throw new PermissionException(Permission.MANAGE_CHANNEL);
        }
        Route.CompiledRoute route = Route.Invites.GET_CHANNEL_INVITES.compile(this.getId());
        return new RestAction<List<Invite>>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    EntityBuilder entityBuilder = EntityBuilder.get(this.api);
                    JSONArray array = response.getArray();
                    ArrayList<Invite> invites = new ArrayList<Invite>(array.length());
                    for (int i = 0; i < array.length(); ++i) {
                        invites.add(entityBuilder.createInvite(array.getJSONObject(i)));
                    }
                    request.onSuccess(invites);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public InviteAction createInvite() {
        if (!this.guild.getSelfMember().hasPermission((Channel)this, Permission.CREATE_INSTANT_INVITE)) {
            throw new PermissionException(Permission.CREATE_INSTANT_INVITE);
        }
        return new InviteAction(this.getJDA(), this.getId());
    }
}

