/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities.impl;

import net.dv8tion.jda.client.entities.Call;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.PrivateChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;

public class PrivateChannelImpl
implements PrivateChannel {
    private final String id;
    private final User user;
    private Call currentCall = null;
    private boolean fake = false;

    public PrivateChannelImpl(String id, User user) {
        this.id = id;
        this.user = user;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public String getName() {
        return this.user.getName();
    }

    @Override
    public ChannelType getType() {
        return ChannelType.PRIVATE;
    }

    @Override
    public JDA getJDA() {
        return this.user.getJDA();
    }

    @Override
    public RestAction<Void> close() {
        Route.CompiledRoute route = Route.Channels.DELETE_CHANNEL.compile(this.id);
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isFake() {
        return this.fake;
    }

    @Override
    public RestAction<Call> startCall() {
        return null;
    }

    @Override
    public Call getCurrentCall() {
        return this.currentCall;
    }

    public PrivateChannelImpl setFake(boolean fake) {
        this.fake = fake;
        return this;
    }

    public PrivateChannelImpl setCurrentCall(Call currentCall) {
        this.currentCall = currentCall;
        return this;
    }

    private void checkNull(Object obj, String name) {
        if (obj == null) {
            throw new NullPointerException("Provided " + name + " was null!");
        }
    }
}

