/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities.impl;

import java.time.OffsetDateTime;
import me.iblitzkriegi.vixio.org.apache.http.util.Args;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Channel;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.Invite;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.exceptions.PermissionException;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import org.json.JSONArray;
import org.json.JSONObject;

public class InviteImpl
implements Invite {
    private final JDAImpl api;
    private final Invite.Channel channel;
    private final String code;
    private final boolean expanded;
    private final Invite.Guild guild;
    private final User inviter;
    private final int maxAge;
    private final int maxUses;
    private final boolean temporary;
    private final OffsetDateTime timeCreated;
    private final int uses;

    public InviteImpl(JDAImpl api, String code, boolean expanded, User inviter, int maxAge, int maxUses, boolean temporary, OffsetDateTime timeCreated, int uses, Invite.Channel channel, Invite.Guild guild) {
        this.api = api;
        this.code = code;
        this.expanded = expanded;
        this.inviter = inviter;
        this.maxAge = maxAge;
        this.maxUses = maxUses;
        this.temporary = temporary;
        this.timeCreated = timeCreated;
        this.uses = uses;
        this.channel = channel;
        this.guild = guild;
    }

    public static RestAction<Invite> resolve(JDA api, String code) {
        Args.notNull(code, "code");
        Args.notNull(api, "api");
        Route.CompiledRoute route = Route.Invites.GET_INVITE.compile(code);
        return new RestAction<Invite>(api, route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    Invite invite = EntityBuilder.get(this.api).createInvite(response.getObject());
                    request.onSuccess(invite);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<Invite> accept() {
        return this.api.asClient().acceptInvite(this);
    }

    @Override
    public RestAction<Invite> delete() {
        Route.CompiledRoute route = Route.Invites.DELETE_INVITE.compile(this.code);
        return new RestAction<Invite>((JDA)this.api, route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    Invite invite = EntityBuilder.get(this.api).createInvite(response.getObject());
                    request.onSuccess(invite);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<Invite> expand() {
        Route.CompiledRoute route;
        Comparable<TextChannel> channel;
        if (this.expanded) {
            return new RestAction.EmptyRestAction<Invite>(this);
        }
        Guild guild = this.api.getGuildById(this.guild.getId());
        if (guild == null) {
            throw new UnsupportedOperationException("You're not in the guild this invite points to");
        }
        Member member = guild.getSelfMember();
        Comparable<TextChannel> comparable = channel = this.channel.getType() == ChannelType.TEXT ? guild.getTextChannelById(this.channel.getId()) : guild.getVoiceChannelById(this.channel.getId());
        if (member.hasPermission((Channel)((Object)channel), Permission.MANAGE_CHANNEL)) {
            route = Route.Invites.GET_CHANNEL_INVITES.compile(channel.getId());
        } else if (member.hasPermission(Permission.MANAGE_SERVER)) {
            route = Route.Invites.GET_GUILD_INVITES.compile(guild.getId());
        } else {
            throw new PermissionException("You don't have the permission to view the full invite info");
        }
        return new RestAction<Invite>((JDA)this.api, route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    EntityBuilder entityBuilder = EntityBuilder.get(this.api);
                    JSONArray array = response.getArray();
                    for (int i = 0; i < array.length(); ++i) {
                        JSONObject object = array.getJSONObject(i);
                        if (!InviteImpl.this.code.equals(object.getString("code"))) continue;
                        request.onSuccess(entityBuilder.createInvite(object));
                        return;
                    }
                    request.onFailure(new RuntimeException("Missing the invite in the channel/guild invite list"));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public Invite.Channel getChannel() {
        return this.channel;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public OffsetDateTime getCreationTime() {
        if (!this.expanded) {
            throw new IllegalStateException("Only valid for expanded invites");
        }
        return this.timeCreated;
    }

    @Override
    public Invite.Guild getGuild() {
        return this.guild;
    }

    @Override
    public User getInviter() {
        if (!this.expanded) {
            throw new IllegalStateException("Only valid for expanded invites");
        }
        return this.inviter;
    }

    @Override
    public JDAImpl getJDA() {
        return this.api;
    }

    @Override
    public int getMaxAge() {
        if (!this.expanded) {
            throw new IllegalStateException("Only valid for expanded invites");
        }
        return this.maxAge;
    }

    @Override
    public int getMaxUses() {
        if (!this.expanded) {
            throw new IllegalStateException("Only valid for expanded invites");
        }
        return this.maxUses;
    }

    @Override
    public int getUses() {
        if (!this.expanded) {
            throw new IllegalStateException("Only valid for expanded invites");
        }
        return this.uses;
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public boolean isTemporary() {
        if (!this.expanded) {
            throw new IllegalStateException("Only valid for expanded invites");
        }
        return this.temporary;
    }

    public String toString() {
        return "Invite(" + this.code + ")";
    }

    public static class GuildImpl
    implements Invite.Guild {
        private final String id;
        private final String iconId;
        private final String name;
        private final String splashId;

        public GuildImpl(String id, String iconId, String name, String splashId) {
            this.id = id;
            this.iconId = iconId;
            this.name = name;
            this.splashId = splashId;
        }

        @Override
        public String getIconId() {
            return this.iconId;
        }

        @Override
        public String getIconUrl() {
            return this.iconId == null ? null : "https://cdn.discordapp.com/icons/" + this.id + "/" + this.iconId + ".jpg";
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getSplashId() {
            return this.splashId;
        }

        @Override
        public String getSplashUrl() {
            return this.splashId == null ? null : "https://cdn.discordapp.com/splashes/" + this.id + "/" + this.splashId + ".jpg";
        }
    }

    public static class ChannelImpl
    implements Invite.Channel {
        private final String id;
        private final String name;
        private final ChannelType type;

        public ChannelImpl(String id, String name, ChannelType type) {
            this.id = id;
            this.name = name;
            this.type = type;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ChannelType getType() {
            return this.type;
        }
    }
}

