/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities;

import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.request.body.MultipartBody;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import me.iblitzkriegi.vixio.org.apache.http.util.Args;
import net.dv8tion.jda.core.AccountType;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.MessageBuilder;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.ISnowflake;
import net.dv8tion.jda.core.entities.Message;
import net.dv8tion.jda.core.entities.MessageEmbed;
import net.dv8tion.jda.core.entities.MessageHistory;
import net.dv8tion.jda.core.entities.impl.MessageImpl;
import net.dv8tion.jda.core.exceptions.AccountTypeException;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;
import net.dv8tion.jda.core.utils.IOUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public interface MessageChannel
extends ISnowflake {
    public String getName();

    public ChannelType getType();

    public JDA getJDA();

    default public RestAction<Message> sendMessage(String text) {
        Args.notEmpty(text, "Provided text for message");
        Args.check(text.length() <= 2000, "Provided text for message must be less than 2000 characters in length");
        return this.sendMessage(new MessageBuilder().append(text).build());
    }

    default public RestAction<Message> sendMessage(MessageEmbed embed) {
        Args.notNull(embed, "Provided embed");
        return this.sendMessage(new MessageBuilder().setEmbed(embed).build());
    }

    default public RestAction<Message> sendMessage(Message msg) {
        Args.notNull(msg, "Message");
        Route.CompiledRoute route = Route.Messages.SEND_MESSAGE.compile(this.getId());
        JSONObject json = ((MessageImpl)msg).toJSONObject();
        return new RestAction<Message>(this.getJDA(), route, (Object)json){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    Message m = EntityBuilder.get(this.getJDA()).createMessage(response.getObject(), MessageChannel.this, false);
                    request.onSuccess(m);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    default public RestAction<Message> sendFile(File file, Message message) throws IOException {
        Args.notNull(file, "file");
        return this.sendFile(file, file.getName(), message);
    }

    default public RestAction<Message> sendFile(File file, String fileName, Message message) throws IOException {
        Args.notNull(file, "file");
        if (file == null || !file.exists() || !file.canRead()) {
            throw new IllegalArgumentException("Provided file is either null, doesn't exist or is not readable!");
        }
        if (file.length() > 0x800000L) {
            throw new IllegalArgumentException("File is to big! Max file-size is 8MB");
        }
        return this.sendFile(IOUtil.readFully(file), fileName, message);
    }

    default public RestAction<Message> sendFile(InputStream data, String fileName, Message message) {
        Args.notNull(data, "data InputStream");
        Args.notNull(fileName, "fileName");
        Route.CompiledRoute route = Route.Messages.SEND_MESSAGE.compile(this.getId());
        MultipartBody body = Unirest.post("https://discordapp.com/api/" + route.getCompiledRoute()).fields(null);
        body.field("file", data, fileName);
        if (message != null) {
            body.field("payload_json", ((MessageImpl)message).toJSONObject().toString());
        }
        return new RestAction<Message>(this.getJDA(), route, (Object)body){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(EntityBuilder.get(this.api).createMessage(response.getObject(), MessageChannel.this, false));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    default public RestAction<Message> sendFile(byte[] data, String fileName, Message message) {
        Args.notNull(data, "file data[]");
        Args.notNull(fileName, "fileName");
        if (data.length > 0x800000) {
            throw new IllegalArgumentException("Provided data is too large! Max file-size is 8MB");
        }
        Route.CompiledRoute route = Route.Messages.SEND_MESSAGE.compile(this.getId());
        MultipartBody body = Unirest.post("https://discordapp.com/api/" + route.getCompiledRoute()).fields(null);
        body.field("file", data, fileName);
        if (message != null) {
            body.field("payload_json", ((MessageImpl)message).toJSONObject().toString());
        }
        return new RestAction<Message>(this.getJDA(), route, (Object)body){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(EntityBuilder.get(this.api).createMessage(response.getObject(), MessageChannel.this, false));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    default public RestAction<Message> getMessageById(String messageId) {
        if (this.getJDA().getAccountType() != AccountType.BOT) {
            throw new AccountTypeException(AccountType.BOT);
        }
        Args.notEmpty(messageId, "Provided messageId");
        Route.CompiledRoute route = Route.Messages.GET_MESSAGE.compile(this.getId(), messageId);
        return new RestAction<Message>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    Message m = EntityBuilder.get(this.getJDA()).createMessage(response.getObject(), MessageChannel.this, false);
                    request.onSuccess(m);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    default public RestAction<Void> deleteMessageById(String messageId) {
        Args.notEmpty(messageId, "messageId");
        Route.CompiledRoute route = Route.Messages.DELETE_MESSAGE.compile(this.getId(), messageId);
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    default public MessageHistory getHistory() {
        return new MessageHistory(this);
    }

    default public RestAction<MessageHistory> getHistoryAround(Message message, int limit) {
        Args.notNull(message, "Provided target message");
        Args.check(message.getChannel().equals(this), "The provided Message is not from the MessageChannel!");
        return this.getHistoryAround(message.getId(), limit);
    }

    default public RestAction<MessageHistory> getHistoryAround(String messageId, int limit) {
        Args.notEmpty(messageId, "Provided messageId");
        Args.check(limit >= 1 && limit <= 100, "Provided limit was out of bounds. Minimum: 1, Max: 100. Provided: %d", (Object)limit);
        Route.CompiledRoute route = Route.Messages.GET_MESSAGE_HISTORY_AROUND.compile(this.getId(), Integer.toString(limit), messageId);
        return new RestAction<MessageHistory>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                MessageHistory mHistory = new MessageHistory(MessageChannel.this);
                EntityBuilder builder = EntityBuilder.get(this.api);
                LinkedList<Message> msgs = new LinkedList<Message>();
                JSONArray historyJson = response.getArray();
                for (int i = 0; i < historyJson.length(); ++i) {
                    msgs.add(builder.createMessage(historyJson.getJSONObject(i), MessageChannel.this, false));
                }
                msgs.forEach(msg -> mHistory.history.put(msg.getId(), (Message)msg));
                request.onSuccess(mHistory);
            }
        };
    }

    default public RestAction<Void> sendTyping() {
        Route.CompiledRoute route = Route.Channels.SEND_TYPING.compile(this.getId());
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    default public RestAction<Void> addReactionById(String messageId, String unicode) {
        String encoded;
        Args.notEmpty(messageId, "MessageId");
        Args.notEmpty(unicode, "Provided Unicode");
        Args.containsNoBlanks(unicode, "Provided Unicode");
        try {
            encoded = URLEncoder.encode(unicode, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        Route.CompiledRoute route = Route.Messages.ADD_REACTION.compile(this.getId(), messageId, encoded);
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    default public RestAction<Void> addReactionById(String messageId, Emote emote) {
        Args.notEmpty(messageId, "MessageId");
        Args.notNull(emote, "Emote");
        Route.CompiledRoute route = Route.Messages.ADD_REACTION.compile(this.getId(), messageId, String.format("%s:%s", emote.getName(), emote.getId()));
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    default public RestAction<Void> pinMessageById(String messageId) {
        Args.notEmpty(messageId, "messageId");
        Route.CompiledRoute route = Route.Messages.ADD_PINNED_MESSAGE.compile(this.getId(), messageId);
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    default public RestAction<Void> unpinMessageById(String messageId) {
        Args.notEmpty(messageId, "messageId");
        Route.CompiledRoute route = Route.Messages.REMOVE_PINNED_MESSAGE.compile(this.getId(), messageId);
        return new RestAction<Void>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    default public RestAction<List<Message>> getPinnedMessages() {
        Route.CompiledRoute route = Route.Messages.GET_PINNED_MESSAGES.compile(this.getId());
        return new RestAction<List<Message>>(this.getJDA(), route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    LinkedList<Message> pinnedMessages = new LinkedList<Message>();
                    EntityBuilder builder = EntityBuilder.get(this.getJDA());
                    JSONArray pins = response.getArray();
                    for (int i = 0; i < pins.length(); ++i) {
                        pinnedMessages.add(builder.createMessage(pins.getJSONObject(i), MessageChannel.this, false));
                    }
                    request.onSuccess(Collections.unmodifiableList(pinnedMessages));
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    default public RestAction<Message> editMessageById(String messageId, String newContent) {
        Args.notEmpty(newContent, "Provided message content");
        Args.check(newContent.length() <= 2000, "Provided newContent length must be 2000 or less characters.");
        return this.editMessageById(messageId, new MessageBuilder().append(newContent).build());
    }

    default public RestAction<Message> editMessageById(String messageId, Message newContent) {
        Args.notEmpty(messageId, "messageId");
        Args.notNull(newContent, "message");
        JSONObject json = ((MessageImpl)newContent).toJSONObject();
        Route.CompiledRoute route = Route.Messages.EDIT_MESSAGE.compile(this.getId(), messageId);
        return new RestAction<Message>(this.getJDA(), route, (Object)json){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    Message m = EntityBuilder.get(this.api).createMessage(response.getObject(), MessageChannel.this, false);
                    request.onSuccess(m);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    default public RestAction<Message> editMessageById(String messageId, MessageEmbed newEmbed) {
        return this.editMessageById(messageId, new MessageBuilder().setEmbed(newEmbed).build());
    }
}

