/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.core.entities;

import java.io.File;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.util.List;
import net.dv8tion.jda.client.entities.Group;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.ChannelType;
import net.dv8tion.jda.core.entities.Emote;
import net.dv8tion.jda.core.entities.Guild;
import net.dv8tion.jda.core.entities.ISnowflake;
import net.dv8tion.jda.core.entities.MessageChannel;
import net.dv8tion.jda.core.entities.MessageEmbed;
import net.dv8tion.jda.core.entities.MessageReaction;
import net.dv8tion.jda.core.entities.MessageType;
import net.dv8tion.jda.core.entities.PrivateChannel;
import net.dv8tion.jda.core.entities.Role;
import net.dv8tion.jda.core.entities.TextChannel;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.requests.Requester;
import net.dv8tion.jda.core.requests.RestAction;

public interface Message
extends ISnowflake {
    public List<User> getMentionedUsers();

    public boolean isMentioned(User var1);

    public List<TextChannel> getMentionedChannels();

    public List<Role> getMentionedRoles();

    public boolean mentionsEveryone();

    public boolean isEdited();

    public OffsetDateTime getEditedTime();

    public User getAuthor();

    public String getContent();

    public String getRawContent();

    public String getStrippedContent();

    public boolean isFromType(ChannelType var1);

    public ChannelType getChannelType();

    public boolean isWebhookMessage();

    public MessageChannel getChannel();

    public PrivateChannel getPrivateChannel();

    public Group getGroup();

    public TextChannel getTextChannel();

    public Guild getGuild();

    public List<Attachment> getAttachments();

    public List<MessageEmbed> getEmbeds();

    public List<Emote> getEmotes();

    public List<MessageReaction> getReactions();

    public boolean isTTS();

    public RestAction<Message> editMessage(String var1);

    public RestAction<Message> editMessage(MessageEmbed var1);

    public RestAction<Message> editMessage(Message var1);

    @Deprecated
    public RestAction<Void> deleteMessage();

    public RestAction<Void> delete();

    public JDA getJDA();

    public boolean isPinned();

    public RestAction<Void> pin();

    public RestAction<Void> unpin();

    public RestAction<Void> addReaction(Emote var1);

    public RestAction<Void> addReaction(String var1);

    public RestAction<Void> clearReactions();

    public MessageType getType();

    public static class Attachment {
        private final String id;
        private final String url;
        private final String proxyUrl;
        private final String fileName;
        private final int size;
        private final int height;
        private final int width;
        private final JDA jda;

        public Attachment(String id, String url, String proxyUrl, String fileName, int size, int height, int width, JDA jda) {
            this.id = id;
            this.url = url;
            this.proxyUrl = proxyUrl;
            this.fileName = fileName;
            this.size = size;
            this.height = height;
            this.width = width;
            this.jda = jda;
        }

        public String getId() {
            return this.id;
        }

        public String getUrl() {
            return this.url;
        }

        public String getProxyUrl() {
            return this.proxyUrl;
        }

        public String getFileName() {
            return this.fileName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean download(File file) {
            InputStream in = null;
            try {
                URL url = new URL(this.getUrl());
                URLConnection con = this.jda.getGlobalProxy() == null ? url.openConnection() : url.openConnection(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.jda.getGlobalProxy().getAddress(), this.jda.getGlobalProxy().getPort())));
                con.addRequestProperty("user-agent", Requester.USER_AGENT);
                in = con.getInputStream();
                Files.copy(in, Paths.get(file.getAbsolutePath(), new String[0]), new CopyOption[0]);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                JDAImpl.LOG.log(e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return false;
        }

        public int getSize() {
            return this.size;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public boolean isImage() {
            return this.height > 0 && this.width > 0;
        }
    }
}

