/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.client.entities.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import me.iblitzkriegi.vixio.org.apache.http.util.Args;
import net.dv8tion.jda.client.JDAClient;
import net.dv8tion.jda.client.entities.CallUser;
import net.dv8tion.jda.client.entities.Friend;
import net.dv8tion.jda.client.entities.Group;
import net.dv8tion.jda.client.entities.Relationship;
import net.dv8tion.jda.client.entities.RelationshipType;
import net.dv8tion.jda.client.entities.UserSettings;
import net.dv8tion.jda.client.entities.impl.UserSettingsImpl;
import net.dv8tion.jda.core.JDA;
import net.dv8tion.jda.core.entities.EntityBuilder;
import net.dv8tion.jda.core.entities.Invite;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.User;
import net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.dv8tion.jda.core.requests.Request;
import net.dv8tion.jda.core.requests.Response;
import net.dv8tion.jda.core.requests.RestAction;
import net.dv8tion.jda.core.requests.Route;

public class JDAClientImpl
implements JDAClient {
    protected final JDAImpl api;
    protected final HashMap<String, Group> groups = new HashMap();
    protected final HashMap<String, Relationship> relationships = new HashMap();
    protected final HashMap<String, CallUser> callUsers = new HashMap();
    protected UserSettingsImpl userSettings;

    public JDAClientImpl(JDAImpl api) {
        this.api = api;
        this.userSettings = new UserSettingsImpl(api);
    }

    @Override
    public JDA getJDA() {
        return this.api;
    }

    @Override
    public List<Group> getGroups() {
        return Collections.unmodifiableList(new ArrayList<Group>(this.groups.values()));
    }

    @Override
    public List<Group> getGroupsByName(String name, boolean ignoreCase) {
        return Collections.unmodifiableList(this.groups.values().stream().filter(g -> g.getName() != null && (ignoreCase ? g.getName().equalsIgnoreCase(name) : g.getName().equals(name))).collect(Collectors.toList()));
    }

    @Override
    public Group getGroupById(String id) {
        return this.groups.get(id);
    }

    @Override
    public List<Relationship> getRelationships() {
        return Collections.unmodifiableList(new ArrayList<Relationship>(this.relationships.values()));
    }

    @Override
    public List<Relationship> getRelationships(RelationshipType type) {
        return Collections.unmodifiableList(this.relationships.values().stream().filter(r -> r.getType().equals((Object)type)).collect(Collectors.toList()));
    }

    @Override
    public List<Relationship> getRelationships(RelationshipType type, String name, boolean ignoreCase) {
        return Collections.unmodifiableList(this.relationships.values().stream().filter(r -> r.getType().equals((Object)type)).filter(r -> ignoreCase ? r.getUser().getName().equalsIgnoreCase(name) : r.getUser().getName().equals(name)).collect(Collectors.toList()));
    }

    @Override
    public List<Relationship> getRelationshipsByName(String name, boolean ignoreCase) {
        return Collections.unmodifiableList(this.relationships.values().stream().filter(r -> ignoreCase ? r.getUser().getName().equalsIgnoreCase(name) : r.getUser().getName().equals(name)).collect(Collectors.toList()));
    }

    @Override
    public Relationship getRelationship(User user) {
        return this.getRelationshipById(user.getId());
    }

    @Override
    public Relationship getRelationship(Member member) {
        return this.getRelationship(member.getUser());
    }

    @Override
    public Relationship getRelationshipById(String id) {
        return this.relationships.get(id);
    }

    @Override
    public Relationship getRelationshipById(String id, RelationshipType type) {
        Relationship relationship = this.getRelationshipById(id);
        if (relationship != null && relationship.getType() == type) {
            return relationship;
        }
        return null;
    }

    @Override
    public List<Friend> getFriends() {
        return this.getRelationships(RelationshipType.FRIEND);
    }

    @Override
    public List<Friend> getFriendsByName(String name, boolean ignoreCase) {
        return this.getRelationships(RelationshipType.FRIEND, name, ignoreCase);
    }

    @Override
    public Friend getFriend(User user) {
        return this.getFriendById(user.getId());
    }

    @Override
    public Friend getFriend(Member member) {
        return this.getFriend(member.getUser());
    }

    @Override
    public Friend getFriendById(String id) {
        return (Friend)this.getRelationshipById(id, RelationshipType.FRIEND);
    }

    @Override
    public UserSettings getSettings() {
        return this.userSettings;
    }

    public HashMap<String, Group> getGroupMap() {
        return this.groups;
    }

    public HashMap<String, Relationship> getRelationshipMap() {
        return this.relationships;
    }

    public HashMap<String, CallUser> getCallUserMap() {
        return this.callUsers;
    }

    @Override
    public RestAction<Invite> acceptInvite(Invite invite) {
        return this.acceptInvite(invite.getCode());
    }

    @Override
    public RestAction<Invite> acceptInvite(String code) {
        Args.notNull(code, "code");
        Route.CompiledRoute route = Route.Invites.ACCEPT_INVITE.compile(code);
        return new RestAction<Invite>((JDA)this.api, route, null){

            @Override
            protected void handleResponse(Response response, Request request) {
                if (response.isOk()) {
                    Invite invite = EntityBuilder.get(this.api).createInvite(response.getObject());
                    request.onSuccess(invite);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }
}

