/*
 * Decompiled with CFR 0.152.
 */
package me.iblitzkriegi.vixio.org.apache.http.nio.protocol;

import java.io.IOException;
import me.iblitzkriegi.vixio.org.apache.http.ContentTooLongException;
import me.iblitzkriegi.vixio.org.apache.http.HttpEntity;
import me.iblitzkriegi.vixio.org.apache.http.HttpEntityEnclosingRequest;
import me.iblitzkriegi.vixio.org.apache.http.HttpRequest;
import me.iblitzkriegi.vixio.org.apache.http.entity.ContentType;
import me.iblitzkriegi.vixio.org.apache.http.nio.ContentDecoder;
import me.iblitzkriegi.vixio.org.apache.http.nio.IOControl;
import me.iblitzkriegi.vixio.org.apache.http.nio.entity.ContentBufferEntity;
import me.iblitzkriegi.vixio.org.apache.http.nio.protocol.AbstractAsyncRequestConsumer;
import me.iblitzkriegi.vixio.org.apache.http.nio.util.HeapByteBufferAllocator;
import me.iblitzkriegi.vixio.org.apache.http.nio.util.SimpleInputBuffer;
import me.iblitzkriegi.vixio.org.apache.http.protocol.HttpContext;
import me.iblitzkriegi.vixio.org.apache.http.util.Asserts;

public class BasicAsyncRequestConsumer
extends AbstractAsyncRequestConsumer<HttpRequest> {
    private volatile HttpRequest request;
    private volatile SimpleInputBuffer buf;

    @Override
    protected void onRequestReceived(HttpRequest request) throws IOException {
        this.request = request;
    }

    @Override
    protected void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        long len = entity.getContentLength();
        if (len > Integer.MAX_VALUE) {
            throw new ContentTooLongException("Entity content is too long: " + len);
        }
        if (len < 0L) {
            len = 4096L;
        }
        this.buf = new SimpleInputBuffer((int)len, new HeapByteBufferAllocator());
        ((HttpEntityEnclosingRequest)this.request).setEntity(new ContentBufferEntity(entity, this.buf));
    }

    @Override
    protected void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        Asserts.notNull(this.buf, "Content buffer");
        this.buf.consumeContent(decoder);
    }

    @Override
    protected void releaseResources() {
        this.request = null;
        this.buf = null;
    }

    @Override
    protected HttpRequest buildResult(HttpContext context) {
        return this.request;
    }
}

