/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.twitch;

import com.sedmelluq.discord.lavaplayer.source.stream.ExtendedM3uParser;
import com.sedmelluq.discord.lavaplayer.source.twitch.TwitchStreamAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.CloseableHttpResponse;
import me.iblitzkriegi.vixio.org.apache.http.client.methods.HttpUriRequest;
import me.iblitzkriegi.vixio.org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchStreamSegmentUrlProvider {
    private static final String TOKEN_PARAMETER = "token";
    private static final Logger log = LoggerFactory.getLogger(TwitchStreamSegmentUrlProvider.class);
    private final String channelName;
    private String streamSegmentPlaylistUrl;
    private String lastSegment;
    private long tokenExpirationTime;

    public TwitchStreamSegmentUrlProvider(String channelName) {
        this.channelName = channelName;
        this.tokenExpirationTime = -1L;
    }

    public String getNextSegmentUrl(HttpInterface httpInterface) {
        try {
            if (!this.obtainSegmentPlaylistUrl(httpInterface)) {
                return null;
            }
            List<String> segments = this.loadStreamSegmentsList(httpInterface);
            String segment = this.chooseNextSegment(segments);
            if (segment == null) {
                return null;
            }
            return TwitchStreamSegmentUrlProvider.createSegmentUrl(this.streamSegmentPlaylistUrl, segment);
        }
        catch (IOException e) {
            throw new FriendlyException("Failed to get next part of the stream.", FriendlyException.Severity.SUSPICIOUS, e);
        }
    }

    private List<String> loadStreamSegmentsList(HttpInterface httpInterface) throws IOException {
        ArrayList<String> segments = new ArrayList<String>();
        for (String lineText : this.getLinesFromUrl(httpInterface, this.streamSegmentPlaylistUrl, "stream segments list")) {
            ExtendedM3uParser.Line line = ExtendedM3uParser.parseLine(lineText);
            if (!line.isData()) continue;
            segments.add(line.lineData);
        }
        return segments;
    }

    private String chooseNextSegment(List<String> segments) {
        String current;
        String selected = null;
        for (int i = segments.size() - 1; i >= 0 && !(current = segments.get(i)).equals(this.lastSegment); --i) {
            selected = current;
        }
        if (selected != null) {
            this.lastSegment = selected;
        }
        return selected;
    }

    private static String createSegmentUrl(String playlistUrl, String segmentName) {
        return playlistUrl.substring(0, playlistUrl.lastIndexOf(47) + 1) + segmentName;
    }

    private boolean obtainSegmentPlaylistUrl(HttpInterface httpInterface) throws IOException {
        if (System.currentTimeMillis() < this.tokenExpirationTime) {
            return true;
        }
        JsonBrowser token = this.loadAccessToken(httpInterface);
        String channelStreamsUrl = this.getChannelStreamsUrl(token).toString();
        ChannelStreams streams = this.loadChannelStreamsList(this.getLinesFromUrl(httpInterface, channelStreamsUrl, "channel streams list"));
        if (streams.entries.isEmpty()) {
            throw new IllegalStateException("No streams available on channel.");
        }
        ChannelStreamInfo stream = (ChannelStreamInfo)streams.entries.get(0);
        log.debug("Chose stream with quality {} from url {}", (Object)stream.quality, (Object)stream.url);
        this.streamSegmentPlaylistUrl = stream.url;
        long tokenServerExpirationTime = JsonBrowser.parse(token.get(TOKEN_PARAMETER).text()).get("expires").as(Long.class) * 1000L;
        this.tokenExpirationTime = System.currentTimeMillis() + (tokenServerExpirationTime - streams.serverTime) - 5000L;
        return true;
    }

    private JsonBrowser loadAccessToken(HttpInterface httpInterface) throws IOException {
        HttpUriRequest request = TwitchStreamAudioSourceManager.createGetRequest("https://api.twitch.tv/api/channels/" + this.channelName + "/access_token?adblock=false&need_https=true&platform=web&player_type=site");
        try (CloseableHttpResponse response = httpInterface.execute(request);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new IOException("Unexpected response code from access token request: " + statusCode);
            }
            JsonBrowser jsonBrowser = JsonBrowser.parse(response.getEntity().getContent());
            return jsonBrowser;
        }
    }

    private ChannelStreams loadChannelStreamsList(String[] lines) throws IOException {
        ExtendedM3uParser.Line twitchInfoLine = null;
        ExtendedM3uParser.Line streamInfoLine = null;
        ArrayList<ChannelStreamInfo> streams = new ArrayList<ChannelStreamInfo>();
        for (String lineText : lines) {
            ExtendedM3uParser.Line line = ExtendedM3uParser.parseLine(lineText);
            if (line.isData() && streamInfoLine != null) {
                String quality = streamInfoLine.directiveArguments.get("VIDEO");
                if (quality != null) {
                    streams.add(new ChannelStreamInfo(quality, line.lineData));
                }
                streamInfoLine = null;
                continue;
            }
            if (!line.isDirective()) continue;
            if ("EXT-X-TWITCH-INFO".equals(line.directiveName)) {
                twitchInfoLine = line;
                continue;
            }
            if (!"EXT-X-STREAM-INF".equals(line.directiveName)) continue;
            streamInfoLine = line;
        }
        return this.buildChannelStreamsList(twitchInfoLine, streams);
    }

    private ChannelStreams buildChannelStreamsList(ExtendedM3uParser.Line twitchInfoLine, List<ChannelStreamInfo> streams) {
        String serverTimeValue;
        String string = serverTimeValue = twitchInfoLine != null ? twitchInfoLine.directiveArguments.get("SERVER-TIME") : null;
        if (serverTimeValue == null) {
            throw new IllegalStateException("Required server time information not available.");
        }
        return new ChannelStreams((long)(Double.valueOf(serverTimeValue) * 1000.0), streams);
    }

    private String[] getLinesFromUrl(HttpInterface httpInterface, String url, String name) throws IOException {
        HttpUriRequest request = TwitchStreamAudioSourceManager.createGetRequest(url);
        try (CloseableHttpResponse response = httpInterface.execute(request);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new IOException("Unexpected response code " + statusCode + " from " + name);
            }
            String[] stringArray = DataFormatTools.streamToLines(response.getEntity().getContent(), StandardCharsets.UTF_8);
            return stringArray;
        }
    }

    private URI getChannelStreamsUrl(JsonBrowser token) {
        try {
            return new URIBuilder("https://usher.ttvnw.net/api/channel/hls/" + this.channelName + ".m3u8").addParameter(TOKEN_PARAMETER, token.get(TOKEN_PARAMETER).text()).addParameter("sig", token.get("sig").text()).addParameter("allow_source", "true").addParameter("allow_spectre", "true").addParameter("player_backend", "html5").addParameter("expgroup", "regular").build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ChannelStreamInfo {
        private final String quality;
        private final String url;

        private ChannelStreamInfo(String quality, String url) {
            this.quality = quality;
            this.url = url;
        }
    }

    private static class ChannelStreams {
        private final long serverTime;
        private final List<ChannelStreamInfo> entries;

        private ChannelStreams(long serverTime, List<ChannelStreamInfo> entries) {
            this.serverTime = serverTime;
            this.entries = entries;
        }
    }
}

