/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.beam;

import com.sedmelluq.discord.lavaplayer.container.adts.AdtsAudioTrack;
import com.sedmelluq.discord.lavaplayer.container.mpegts.MpegTsElementaryInputStream;
import com.sedmelluq.discord.lavaplayer.container.mpegts.PesPacketInputStream;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.beam.BeamAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.beam.BeamSegmentUrlProvider;
import com.sedmelluq.discord.lavaplayer.tools.io.ChainedInputStream;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.DelegatedAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamAudioTrack
extends DelegatedAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(BeamAudioTrack.class);
    private final BeamAudioSourceManager sourceManager;
    private final BeamSegmentUrlProvider segmentUrlProvider;

    public BeamAudioTrack(AudioTrackInfo trackInfo, BeamAudioSourceManager sourceManager) {
        super(trackInfo);
        this.sourceManager = sourceManager;
        this.segmentUrlProvider = new BeamSegmentUrlProvider(this.getChannelId());
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws Exception {
        log.debug("Starting to play Beam channel {}.", (Object)this.getChannelUrl());
        try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();
             ChainedInputStream chainedInputStream = new ChainedInputStream(() -> this.segmentUrlProvider.getNextSegmentStream(httpInterface));){
            MpegTsElementaryInputStream elementaryInputStream = new MpegTsElementaryInputStream(chainedInputStream, 15);
            PesPacketInputStream pesPacketInputStream = new PesPacketInputStream(elementaryInputStream);
            this.processDelegate(new AdtsAudioTrack(this.trackInfo, pesPacketInputStream), localExecutor);
        }
    }

    @Override
    public AudioTrack makeClone() {
        return new BeamAudioTrack(this.trackInfo, this.sourceManager);
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }

    private String getChannelId() {
        return this.trackInfo.identifier.substring(0, this.trackInfo.identifier.indexOf(124));
    }

    private String getChannelUrl() {
        return this.trackInfo.identifier.substring(this.trackInfo.identifier.lastIndexOf(124) + 1);
    }
}

